/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.wizards.datatransfer.EasymportJob;
import org.eclipse.ui.internal.wizards.datatransfer.Messages;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.internal.wizards.datatransfer.RecursiveImportListener;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class EasymportJobReportDialog
extends Dialog {
    private EasymportJob job;
    private IJobChangeListener jobChangeListener;
    private StackLayout progressLayout;
    private Composite progressComposite;
    private ProgressBar progressBar;
    private Label completedStatusLabel;
    private Label abortedStatusLabel;
    private Button stopButton;
    private boolean cancel;

    public EasymportJobReportDialog(Shell shell, EasymportJob job) {
        super(shell);
        this.setShellStyle(144);
        this.job = job;
        this.jobChangeListener = new IJobChangeListener(){

            public void sleeping(IJobChangeEvent arg0) {
            }

            public void scheduled(IJobChangeEvent arg0) {
            }

            public void running(IJobChangeEvent arg0) {
            }

            public void done(IJobChangeEvent jobEvent) {
                if (jobEvent.getJob() == EasymportJobReportDialog.this.job && EasymportJobReportDialog.this.getShell() != null) {
                    EasymportJobReportDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ((EasymportJobReportDialog)(this).EasymportJobReportDialog.this).progressLayout.topControl.setVisible(false);
                            ((EasymportJobReportDialog)(this).EasymportJobReportDialog.this).progressLayout.topControl = !EasymportJobReportDialog.this.cancel ? EasymportJobReportDialog.this.completedStatusLabel : EasymportJobReportDialog.this.abortedStatusLabel;
                            EasymportJobReportDialog.this.progressComposite.layout();
                            EasymportJobReportDialog.this.updateButtons();
                        }
                    });
                }
            }

            public void awake(IJobChangeEvent arg0) {
            }

            public void aboutToRun(IJobChangeEvent arg0) {
            }
        };
        Job.getJobManager().addJobChangeListener(this.jobChangeListener);
    }

    public Composite createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EasymportWizardPage_nestedProjects);
        final Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        res.setLayoutData((Object)new GridData(4, 4, true, true));
        final Label nestedProjectsLabel = new Label(res, 0);
        nestedProjectsLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        nestedProjectsLabel.setText(NLS.bind((String)Messages.EasymportWizardPage_importedProjects, (Object)0));
        final TableViewer nestedProjectsTable = new TableViewer(res);
        nestedProjectsTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object root) {
                return ((Map)root).entrySet().toArray();
            }
        });
        nestedProjectsTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                IProject project1 = (IProject)((Map.Entry)o1).getKey();
                IProject project2 = (IProject)((Map.Entry)o2).getKey();
                return project1.getLocation().toString().compareTo(project2.getLocation().toString());
            }
        });
        nestedProjectsTable.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Map.Entry entry = (Map.Entry)element;
                return ((IProject)entry.getKey()).getLocation().toFile().getAbsolutePath().startsWith(EasymportJobReportDialog.this.job.getRoot().getAbsolutePath());
            }
        }});
        nestedProjectsTable.getTable().setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 2, 1);
        tableLayoutData.heightHint = 400;
        nestedProjectsTable.getControl().setLayoutData((Object)tableLayoutData);
        TableViewerColumn projectColumn = new TableViewerColumn(nestedProjectsTable, 2816);
        projectColumn.getColumn().setWidth(200);
        projectColumn.getColumn().setText(Messages.EasymportWizardPage_project);
        projectColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IProject)((Map.Entry)element).getKey()).getName();
            }
        });
        TableViewerColumn configuratorsColumn = new TableViewerColumn(nestedProjectsTable, 0);
        configuratorsColumn.getColumn().setWidth(300);
        configuratorsColumn.getColumn().setText(Messages.EasymportWizardPage_natures);
        configuratorsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                StringBuilder builder = new StringBuilder();
                for (ProjectConfigurator configurator : (List)((Map.Entry)element).getValue()) {
                    builder.append(ProjectConfiguratorExtensionManager.getLabel(configurator));
                    builder.append(", ");
                }
                if (builder.length() > 0) {
                    builder.delete(builder.length() - 2, builder.length());
                }
                return builder.toString();
            }
        });
        TableViewerColumn relativePathColumn = new TableViewerColumn(nestedProjectsTable, 16384);
        relativePathColumn.getColumn().setText(Messages.EasymportWizardPage_relativePath);
        relativePathColumn.getColumn().setWidth(300);
        relativePathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IProject project = (IProject)((Map.Entry)element).getKey();
                IPath projectLocation = project.getLocation();
                return projectLocation.toFile().getAbsolutePath().substring(EasymportJobReportDialog.this.job.getRoot().getAbsolutePath().length());
            }
        });
        nestedProjectsTable.setInput(this.job.getConfiguredProjects());
        final Label errorsLabel = new Label(res, 0);
        GridData errorLabelLayoutData = new GridData(4, 0, true, false, 2, 1);
        errorLabelLayoutData.exclude = true;
        errorsLabel.setLayoutData((Object)errorLabelLayoutData);
        errorsLabel.setText(NLS.bind((String)Messages.EasymportWizardPage_importErrors, (Object)0));
        final TableViewer errorsTable = new TableViewer(res);
        errorsTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object root) {
                return ((Map)root).entrySet().toArray();
            }
        });
        errorsTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                IPath location1 = (IPath)((Map.Entry)o1).getKey();
                IPath location2 = (IPath)((Map.Entry)o2).getKey();
                return location1.toString().compareTo(location2.toString());
            }
        });
        errorsTable.getTable().setHeaderVisible(true);
        GridData errorTableLayoutData = new GridData(4, 4, true, true, 2, 1);
        errorTableLayoutData.heightHint = 100;
        errorTableLayoutData.exclude = true;
        errorsTable.getControl().setLayoutData((Object)errorTableLayoutData);
        TableViewerColumn errorRelativePathColumn = new TableViewerColumn(errorsTable, 16384);
        errorRelativePathColumn.getColumn().setText(Messages.EasymportWizardPage_relativePath);
        errorRelativePathColumn.getColumn().setWidth(300);
        errorRelativePathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Path rootLocation = new Path(EasymportJobReportDialog.this.job.getRoot().getAbsolutePath());
                IPath projectLocation = (IPath)((Map.Entry)element).getKey();
                return projectLocation.makeRelativeTo((IPath)rootLocation).toString();
            }
        });
        TableViewerColumn errorColumn = new TableViewerColumn(errorsTable, 16384);
        errorColumn.getColumn().setText(Messages.EasymportWizardPage_error);
        errorColumn.getColumn().setWidth(500);
        errorColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Exception)((Map.Entry)element).getValue()).getMessage();
            }
        });
        errorsTable.setInput(this.job.getErrors());
        RecursiveImportListener tableReportFiller = new RecursiveImportListener(){

            @Override
            public void projectCreated(IProject project) {
                if (EasymportJobReportDialog.this.getShell().getDisplay() == null) {
                    return;
                }
                EasymportJobReportDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        nestedProjectsTable.refresh();
                        nestedProjectsTable.getTable().update();
                        nestedProjectsTable.getTable().redraw();
                        nestedProjectsLabel.setText(NLS.bind((String)Messages.EasymportWizardPage_importedProjects, (Object)EasymportJobReportDialog.this.job.getConfiguredProjects().size()));
                    }
                });
            }

            @Override
            public void projectConfigured(IProject project, ProjectConfigurator configurator) {
                nestedProjectsTable.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        nestedProjectsTable.refresh();
                        nestedProjectsTable.getTable().update();
                        nestedProjectsTable.getTable().redraw();
                    }
                });
            }

            @Override
            public void errorHappened(IPath location, Exception error) {
                errorsTable.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GridData gridData = (GridData)errorsTable.getControl().getLayoutData();
                        if (gridData.exclude) {
                            gridData.exclude = false;
                            ((GridData)errorsLabel.getLayoutData()).exclude = false;
                        }
                        errorsTable.refresh();
                        errorsTable.getTable().update();
                        errorsLabel.setText(NLS.bind((String)Messages.EasymportWizardPage_importErrors, (Object)EasymportJobReportDialog.this.job.getErrors().size()));
                        res.layout(true);
                    }
                });
            }
        };
        this.job.setListener(tableReportFiller);
        this.progressComposite = new Composite(res, 0);
        this.progressComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressLayout = new StackLayout();
        this.progressComposite.setLayout((Layout)this.progressLayout);
        this.progressBar = new ProgressBar(this.progressComposite, 65538);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressBar.setToolTipText(Messages.EasymportWizardPage_progressBarTooltip);
        this.completedStatusLabel = new Label(this.progressComposite, 0);
        this.completedStatusLabel.setText("Completed");
        this.abortedStatusLabel = new Label(this.progressComposite, 0);
        this.abortedStatusLabel.setText("Aborted");
        this.progressLayout.topControl = this.progressBar;
        this.stopButton = new Button(res, 8);
        this.stopButton.setToolTipText("Abort");
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EasymportJobReportDialog.this.cancel = true;
                EasymportJobReportDialog.this.job.cancel();
            }
        });
        this.stopButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        this.stopButton.setImage(WorkbenchImages.getImage((String)"IMG_ELCL_STOP"));
        return res;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EasymportJobReportDialog.this.close();
            }
        });
        this.updateButtons();
    }

    private void updateButtons() {
        this.stopButton.setEnabled(this.job.getResult() == null);
        this.getButton(0).setEnabled(this.job.getResult() != null);
    }

    public boolean close() {
        Job.getJobManager().removeJobChangeListener(this.jobChangeListener);
        return super.close();
    }
}

