/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.libprov;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.portlet.core.Messages;
import org.jboss.tools.portlet.core.PortletCoreActivator;
import org.jboss.tools.portlet.core.libprov.AbstractLibraryProviderInstallOperationConfig;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSFPortletbridgeRuntimeLibraryProviderInstallOperationConfig
extends AbstractLibraryProviderInstallOperationConfig {
    private String portletbridgeHome;

    public synchronized IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        if (this.isEPP()) {
            return status;
        }
        if (this.portletbridgeHome == null) {
            return this.getInvalidPortletbridgeRuntime();
        }
        this.portletbridgeHome = this.portletbridgeHome.trim();
        if (this.portletbridgeHome.length() <= 0) {
            status = new Status(4, "org.jboss.tools.portlet.core", Messages.JSFPortletFacetInstallPage_Portletbridge_Runtime_directory_is_required);
            return status;
        }
        File folder = new File(this.portletbridgeHome);
        if (!folder.exists() || !folder.isDirectory()) {
            return this.getInvalidPortletbridgeRuntime();
        }
        String[] fileList = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.startsWith("portletbridge") && name.endsWith(".jar")) {
                    return true;
                }
                return name.equals("examples");
            }
        });
        if (fileList.length < 3) {
            return this.getInvalidPortletbridgeRuntime();
        }
        return Status.OK_STATUS;
    }

    private IStatus getInvalidPortletbridgeRuntime() {
        Status status = new Status(4, "org.jboss.tools.portlet.core", Messages.JSFPortletFacetInstallPage_Invalid_Portletbridge_Runtime_directory);
        return status;
    }

    public String getPortletbridgeHome() {
        if (this.isEPP()) {
            return PortletCoreActivator.getEPPDir(this.getFacetedProject(), "portletbridge").getAbsolutePath();
        }
        return this.portletbridgeHome;
    }

    public void setPortletbridgeHome(String portletbridgeHome) {
        String oldValue = this.portletbridgeHome;
        this.portletbridgeHome = portletbridgeHome;
        this.notifyListeners("portletbridgeHome", oldValue, portletbridgeHome);
        this.updatePreferences();
    }

    public void init(IFacetedProjectBase fpj, IProjectFacetVersion fv, ILibraryProvider provider) {
        super.init(fpj, fv, provider);
        this.reset();
    }

    public void reset() {
        super.reset();
        IProjectFacet f = this.getProjectFacet();
        try {
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)f);
            prefs = prefs.node("portletBridgeHome");
            if (prefs.nodeExists("jsfportlet.library.provider/portletbridge_home")) {
                this.portletbridgeHome = prefs.get("jsfportlet.library.provider/portletbridge_home", null);
            }
        }
        catch (BackingStoreException e) {
            PortletCoreActivator.log(e);
        }
    }

    private void updatePreferences() {
        IProjectFacet f = this.getProjectFacet();
        try {
            Preferences prefs = FacetedProjectFramework.getPreferences((IProjectFacet)f);
            prefs = prefs.node("portletBridgeHome");
            prefs.put("jsfportlet.library.provider/portletbridge_home", this.portletbridgeHome);
        }
        catch (BackingStoreException e) {
            PortletCoreActivator.log(e);
        }
    }
}

