/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.core.internal.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class PortletUtil {
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String PORTLETBRIDGE_API = "portletbridge-api";
    private static final String PORTLETBRIDGE_CORE_API = "portletbridge-core-api";
    private static final String JAR = ".jar";

    public static int getPortletBridgeVersion(IProject project) {
        block8: {
            if (project == null || !project.isOpen()) {
                return 0;
            }
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer folder = rootFolder.getUnderlyingFolder();
            IFolder webinf = folder.getFolder((IPath)new Path("WEB-INF/lib"));
            String libResource = webinf.getLocation().toOSString();
            File libFile = new File(libResource);
            if (!libFile.exists()) {
                return 0;
            }
            File[] files = libFile.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name != null && name.startsWith(PortletUtil.PORTLETBRIDGE_API) && name.endsWith(PortletUtil.JAR)) {
                        return true;
                    }
                    return name != null && name.startsWith(PortletUtil.PORTLETBRIDGE_CORE_API) && name.endsWith(PortletUtil.JAR);
                }
            });
            if (files == null || files.length <= 0) {
                return 0;
            }
            File jarFile = files[0];
            if (jarFile.isFile()) {
                try {
                    StringTokenizer tokenizer;
                    JarFile jar = new JarFile(jarFile);
                    Attributes attributes = jar.getManifest().getMainAttributes();
                    String versionString = attributes.getValue(IMPLEMENTATION_VERSION);
                    if (versionString == null || versionString.trim().length() <= 0 || !(tokenizer = new StringTokenizer(versionString, ".")).hasMoreTokens()) break block8;
                    String firstNumber = tokenizer.nextToken();
                    int version = 0;
                    try {
                        version = new Integer(firstNumber);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    return version;
                }
                catch (IOException iOException) {
                    return 0;
                }
            }
        }
        return 0;
    }
}

