/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.runtimes.tomcat.internal.detection;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.wtp.runtimes.tomcat.internal.detection.RuntimeTomcatActivator;
import org.jboss.tools.wtp.runtimes.tomcat.internal.detection.ServerUtils;

public class TomcatRuntimeDetectorDelegate
extends AbstractRuntimeDetectorDelegate {
    private static final String RUNTIME_SUFFIX = " Runtime";
    protected static final String[] runtimeTypes = new String[]{"org.eclipse.jst.server.tomcat.runtime.80", "org.eclipse.jst.server.tomcat.runtime.70", "org.eclipse.jst.server.tomcat.runtime.60", "org.eclipse.jst.server.tomcat.runtime.55", "org.eclipse.jst.server.tomcat.runtime.50", "org.eclipse.jst.server.tomcat.runtime.41", "org.eclipse.jst.server.tomcat.runtime.40", "org.eclipse.jst.server.tomcat.runtime.32"};
    protected static final HashMap<String, IExecutionEnvironment> environmentMap = new HashMap();
    public static final String TOMCAT_TYPE = "TOMCAT";

    static {
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.32", EnvironmentsManager.getDefault().getEnvironment("J2SE-1.3"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.40", EnvironmentsManager.getDefault().getEnvironment("J2SE-1.3"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.41", EnvironmentsManager.getDefault().getEnvironment("J2SE-1.3"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.50", EnvironmentsManager.getDefault().getEnvironment("J2SE-1.4"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.55", EnvironmentsManager.getDefault().getEnvironment("J2SE-1.4"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.60", EnvironmentsManager.getDefault().getEnvironment("J2SE-1.5"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.70", EnvironmentsManager.getDefault().getEnvironment("JavaSE-1.6"));
        environmentMap.put("org.eclipse.jst.server.tomcat.runtime.80", EnvironmentsManager.getDefault().getEnvironment("JavaSE-1.7"));
    }

    @Deprecated
    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        for (RuntimeDefinition runtimeDef : runtimeDefinitions) {
            try {
                this.initializeRuntime(runtimeDef);
            }
            catch (CoreException ce) {
                RuntimeTomcatActivator.logError("An error occured while creating a tomcat server", ce);
            }
        }
    }

    public boolean initializeRuntime(RuntimeDefinition runtimeDef) throws CoreException {
        boolean ret = false;
        if (runtimeDef instanceof TomcatRuntimeDefinition) {
            TomcatRuntimeDefinition trd = (TomcatRuntimeDefinition)runtimeDef;
            NullProgressMonitor monitor = new NullProgressMonitor();
            IRuntimeWorkingCopy trwc = this.getTomcatRuntimeWorkingCopy(trd.getLocation(), trd.getRuntimeTypeId(), (IProgressMonitor)monitor);
            if (trwc != null) {
                try {
                    String serverName = trwc.getName();
                    IRuntime runtime = trwc.getOriginal();
                    if (runtime == null) {
                        runtime = this.createRuntime(trwc, (IProgressMonitor)monitor);
                    }
                    if (runtime != null) {
                        ret = true;
                        IServerType serverType = this.findServerType(runtime.getRuntimeType());
                        if (serverType != null) {
                            TomcatRuntimeDetectorDelegate.createServer(runtime, serverName, serverType, (IProgressMonitor)monitor);
                        }
                    }
                }
                catch (CoreException e) {
                    RuntimeTomcatActivator.logError("An error occured while creating a tomcat server", e);
                }
            }
        }
        return ret;
    }

    private IRuntime createRuntime(IRuntimeWorkingCopy trwc, IProgressMonitor monitor) throws CoreException {
        if (trwc != null) {
            if (!trwc.getName().endsWith(RUNTIME_SUFFIX)) {
                trwc.setName(String.valueOf(trwc.getName()) + RUNTIME_SUFFIX);
            }
            trwc.save(true, monitor);
            return trwc.getOriginal();
        }
        return null;
    }

    private IServerType findServerType(IRuntimeType runtimeType) {
        if (runtimeType != null) {
            IServerType[] iServerTypeArray = ServerCore.getServerTypes();
            int n = iServerTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServerType serverType = iServerTypeArray[n2];
                if (runtimeType.equals(serverType.getRuntimeType())) {
                    return serverType;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void createServer(IRuntime runtime, String name, IServerType serverType, IProgressMonitor monitor) throws CoreException {
        if (name.endsWith(RUNTIME_SUFFIX)) {
            name = name.substring(0, name.lastIndexOf(RUNTIME_SUFFIX));
        }
        String uniqueName = ServerUtils.getUniqueServerName(name);
        IServerWorkingCopy serverWC = serverType.createServer(null, null, monitor);
        serverWC.setRuntime(runtime);
        serverWC.setName(uniqueName);
        serverWC.save(true, monitor);
    }

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (monitor.isCanceled() || root == null) {
            return null;
        }
        TomcatRuntimeDefinition rd = null;
        IRuntimeWorkingCopy rwc = this.searchDir(root, monitor);
        if (rwc != null) {
            rd = new TomcatRuntimeDefinition(rwc.getName(), rwc.getRuntimeType().getVersion(), TOMCAT_TYPE, root, rwc.getRuntimeType().getId());
        }
        return rd;
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        String path = this.getLocationForRuntimeDefinition(runtimeDefinition);
        if (path == null) {
            return false;
        }
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            IRuntime runtime = servers[i].getRuntime();
            if (runtime != null && runtime.getLocation() != null && this.isRuntimeMatchLocation(path, runtime)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isRuntimeMatchLocation(String absolutePath, IRuntime runtime) {
        if (runtime == null || runtime.getLocation() == null || absolutePath == null) {
            return false;
        }
        String loc = runtime.getLocation().toOSString();
        try {
            loc = new File(loc).getCanonicalPath();
        }
        catch (IOException e) {
            RuntimeTomcatActivator.logError(e);
        }
        return absolutePath.equals(loc);
    }

    private String getLocationForRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
        File location;
        String path = null;
        if (runtimeDefinition != null && runtimeDefinition.getLocation() != null && (location = runtimeDefinition.getLocation()) != null && location.isDirectory()) {
            try {
                path = location.getCanonicalPath();
            }
            catch (IOException e) {
                RuntimeTomcatActivator.logError(e);
                path = location.getAbsolutePath();
            }
        }
        return path;
    }

    private IRuntimeWorkingCopy searchDir(File dir, IProgressMonitor monitor) {
        File conf = new File(dir, "conf");
        if (conf.isDirectory() && conf.exists()) {
            return this.getRuntimeWorkingCopyFromDir(dir, monitor);
        }
        return null;
    }

    private IRuntimeWorkingCopy getRuntimeWorkingCopyFromDir(File dir, IProgressMonitor monitor) {
        String[] stringArray = runtimeTypes;
        int n = runtimeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String runtimeTypeId = stringArray[n2];
            IRuntimeWorkingCopy rwc = this.getTomcatRuntimeWorkingCopy(dir, runtimeTypeId, monitor);
            if (rwc != null) {
                ITomcatRuntimeWorkingCopy cfr_ignored_0 = (ITomcatRuntimeWorkingCopy)rwc.loadAdapter(ITomcatRuntimeWorkingCopy.class, null);
                return rwc;
            }
            ++n2;
        }
        return null;
    }

    private IRuntimeWorkingCopy getTomcatRuntimeWorkingCopy(File dir, String runtimeTypeId, IProgressMonitor monitor) {
        try {
            IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypeId);
            String absolutePath = dir.getAbsolutePath();
            IRuntime runtime = this.getRuntimeAt(runtimeTypeId, absolutePath);
            IRuntimeWorkingCopy runtimeWc = null;
            if (runtime == null) {
                String id = absolutePath.replace(File.separatorChar, '_').replace(':', '-');
                runtimeWc = runtimeType.createRuntime(id, monitor);
                runtimeWc.setName(dir.getName());
                runtimeWc.setLocation((IPath)new Path(absolutePath));
                ITomcatRuntimeWorkingCopy wc = (ITomcatRuntimeWorkingCopy)runtimeWc.loadAdapter(ITomcatRuntimeWorkingCopy.class, null);
                wc.setVMInstall(this.findVMForRuntimeType(runtimeTypeId));
            } else {
                runtimeWc = runtime.createWorkingCopy();
            }
            IStatus status = runtimeWc.validate(monitor);
            if (status == null || status.getSeverity() != 4) {
                return runtimeWc;
            }
        }
        catch (Exception e) {
            RuntimeTomcatActivator.logError("Could not find runtime", e);
        }
        return null;
    }

    private IVMInstall findVMForRuntimeType(String runtimeTypeId) {
        IExecutionEnvironment env = environmentMap.get(runtimeTypeId);
        if (env != null) {
            IVMInstall install = env.getDefaultVM();
            if (install != null) {
                return install;
            }
            IVMInstall[] arr = env.getCompatibleVMs();
            if (arr != null && arr.length > 0) {
                return arr[0];
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    private IRuntime getRuntimeAt(String runtimeTypeId, String absolutePath) {
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null && runtimeTypeId.equals(runtimeType.getId()) && this.isRuntimeMatchLocation(absolutePath, runtime)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    public static class TomcatRuntimeDefinition
    extends RuntimeDefinition {
        private String runtimeTypeId;

        public TomcatRuntimeDefinition(String name, String version, String type, File location, String runtimeTypeId) {
            super(name, version, type, location);
            this.runtimeTypeId = runtimeTypeId;
        }

        public String getRuntimeTypeId() {
            return this.runtimeTypeId;
        }
    }
}

