/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.ui.ManageDevicesDialog;
import org.jboss.tools.browsersim.ui.model.preferences.CommonPreferences;
import org.jboss.tools.browsersim.ui.model.preferences.SpecificPreferences;
import org.jboss.tools.browsersim.ui.model.preferences.SpecificPreferencesStorage;
import org.jboss.tools.cordovasim.CordovaSimArgs;
import org.jboss.tools.cordovasim.Messages;
import org.jboss.tools.cordovasim.model.preferences.CordavaSimSpecificPreferencesStorage;
import org.jboss.tools.cordovasim.model.preferences.CordovaSimSpecificPreferences;

public class CordovaSimManageDeviceDialog
extends ManageDevicesDialog {
    private static final String CORDOVASIM_RESTART_COMMAND = "org.jboss.tools.cordavasim.command.restart:";
    private static final String PARAMETER_DELIMITER = "_PARAMETER_DELIMITER_";
    private Button DontShowUnsupportedPluginsCheckBox;
    private boolean showUnsupportedPlugins;

    public CordovaSimManageDeviceDialog(Shell parent, int style, CommonPreferences oldCommonPreferences, SpecificPreferences oldSpecificPreferences, String currentUrl) {
        super(parent, style, oldCommonPreferences, oldSpecificPreferences, currentUrl);
        this.showUnsupportedPlugins = ((CordovaSimSpecificPreferences)oldSpecificPreferences).showUnsupportedPluginsPopUp();
    }

    protected SpecificPreferencesStorage getSpecificPreferencesStorage() {
        return CordavaSimSpecificPreferencesStorage.INSTANCE;
    }

    protected void loadDefaultPreferences() {
        CordovaSimSpecificPreferences defaultPreferences = (CordovaSimSpecificPreferences)this.getSpecificPreferencesStorage().loadDefault();
        this.showUnsupportedPlugins = defaultPreferences.showUnsupportedPluginsPopUp();
        super.loadDefaultPreferences();
    }

    protected void createContents() {
        super.createContents();
        Group unsupportedPluginsGroup = new Group(this.settingsComposite, 0);
        unsupportedPluginsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        unsupportedPluginsGroup.setText(Messages.CordovaSimManageDevicesDialog_UNSUPPORTED_PLUGINS);
        unsupportedPluginsGroup.setLayout((Layout)new GridLayout(2, false));
        this.DontShowUnsupportedPluginsCheckBox = new Button((Composite)unsupportedPluginsGroup, 32);
        this.DontShowUnsupportedPluginsCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.DontShowUnsupportedPluginsCheckBox.setText(Messages.CordovaSimManageDevicesDialog_UNSUPPORTED_PLUGINS_CHECKBOX);
    }

    public void updateDevices() {
        super.updateDevices();
        this.DontShowUnsupportedPluginsCheckBox.setSelection(!this.showUnsupportedPlugins);
    }

    protected SpecificPreferences create(String selectedDeviceId, boolean useSkins, boolean enableLiveReload, int liveReloadPort, boolean enableTouchEvents, boolean isJavaFx) {
        return new CordovaSimSpecificPreferences(selectedDeviceId, useSkins, enableLiveReload, liveReloadPort, enableTouchEvents, this.oldSpecificPreferences.getOrientationAngle(), this.getParent().getLocation(), ((CordovaSimSpecificPreferences)this.oldSpecificPreferences).getCordovaBrowserLocation(), ((CordovaSimSpecificPreferences)this.oldSpecificPreferences).getCordovaBrowserSize(), isJavaFx, !this.DontShowUnsupportedPluginsCheckBox.getSelection(), ((CordovaSimSpecificPreferences)this.oldSpecificPreferences).getRipplePreferences());
    }

    protected void sendRestartCommand() {
        CordovaSimArgs.setRestartRequired(true);
        System.out.println(this.generateRestartCommand());
    }

    private String generateRestartCommand() {
        String command = "org.jboss.tools.cordavasim.command.restart:_PARAMETER_DELIMITER_" + CordovaSimArgs.getRootFolder() + PARAMETER_DELIMITER + CordovaSimArgs.getHomeUrl() + PARAMETER_DELIMITER + "-version" + PARAMETER_DELIMITER + CordovaSimArgs.getCordovaVersion();
        String proxy = CordovaSimArgs.getProxy();
        if (proxy != null) {
            command = String.valueOf(command) + "_PARAMETER_DELIMITER_-proxy_PARAMETER_DELIMITER_" + proxy;
        }
        return command;
    }
}

