/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.Activator;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class JavaProjectNature
implements ProjectConfigurator {
    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        JavaResourceExistsFinder javaResourceFinder = new JavaResourceExistsFinder(ignoredDirectories);
        try {
            project.accept((IResourceVisitor)javaResourceFinder);
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.ui.importer.java", ex.getMessage(), (Throwable)ex));
            return false;
        }
        return javaResourceFinder.hasJavaFile();
    }

    public IWizard getConfigurationWizard() {
        return null;
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            List<String> natures = Arrays.asList(description.getNatureIds());
            if (!natures.contains("org.eclipse.jdt.core.javanature")) {
                ArrayList<String> newNatures = new ArrayList<String>(natures);
                newNatures.add("org.eclipse.jdt.core.javanature");
                description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
                project.setDescription(description, monitor);
                IJavaProject javaNature = JavaCore.create((IProject)project);
                javaNature.open(monitor);
                List<IClasspathEntry> classpathEntries = Arrays.asList(javaNature.getRawClasspath());
                ArrayList<IClasspathEntry> newClasspathEntries = new ArrayList<IClasspathEntry>(classpathEntries);
                newClasspathEntries.add(JavaRuntime.getDefaultJREContainerEntry());
                JavaResourceFinder javaResourceFinder = new JavaResourceFinder(ignoredDirectories);
                project.accept((IResourceVisitor)javaResourceFinder);
                Set<IContainer> sourceFolders = javaResourceFinder.getSourceFolders();
                if (!sourceFolders.isEmpty()) {
                    HashSet<IClasspathEntry> toRemove = new HashSet<IClasspathEntry>();
                    for (IClasspathEntry entry : newClasspathEntries) {
                        if (entry.getEntryKind() != 3) continue;
                        toRemove.add(entry);
                    }
                    newClasspathEntries.removeAll(toRemove);
                    for (IContainer container : sourceFolders) {
                        newClasspathEntries.add(JavaCore.newSourceEntry((IPath)container.getFullPath()));
                    }
                }
                javaNature.setRawClasspath(newClasspathEntries.toArray(new IClasspathEntry[newClasspathEntries.size()]), monitor);
            }
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.ui.importer.java", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return false;
    }

    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (javaProject == null) {
                return res;
            }
            IResource resource = project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
            if (resource != null && resource.exists() && resource.getType() == 2) {
                res.add((IFolder)resource);
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IFolder sourceFolder = project.getFolder(entry.getPath());
                    res.add(sourceFolder);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.log(4, ex.getMessage());
        }
        return res;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return null;
    }

    private static final class JavaResourceExistsFinder
    implements IResourceVisitor {
        private boolean hasJavaFile;
        private Set<IPath> ignoredDirectories;

        public JavaResourceExistsFinder(Set<IPath> ignoredDirectories) {
            this.ignoredDirectories = ignoredDirectories;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.ignoredDirectories != null) {
                for (IPath ignoredDirectory : this.ignoredDirectories) {
                    if (!ignoredDirectory.isPrefixOf(resource.getLocation())) continue;
                    return false;
                }
            }
            this.hasJavaFile = this.hasJavaFile || resource.getType() == 1 && resource.getName().endsWith(".java");
            return !this.hasJavaFile;
        }

        public boolean hasJavaFile() {
            return this.hasJavaFile;
        }
    }

    private static final class JavaResourceFinder
    implements IResourceVisitor {
        private Set<IContainer> mostLikelySourceFolders = new HashSet<IContainer>();
        private static final String PACKAGE_KEYWORD = "package";
        private Set<IPath> ignoredDirectories;

        public JavaResourceFinder(Set<IPath> ignoredDirectories) {
            this.ignoredDirectories = ignoredDirectories;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.ignoredDirectories != null) {
                for (IPath ignoredDirectory : this.ignoredDirectories) {
                    if (!ignoredDirectory.isPrefixOf(resource.getLocation())) continue;
                    return false;
                }
            }
            boolean alreadyInAResourceFolder = false;
            IResource aParentResource = resource;
            while (!alreadyInAResourceFolder && aParentResource.getType() != 8) {
                alreadyInAResourceFolder = this.mostLikelySourceFolders.contains(aParentResource);
                aParentResource = aParentResource.getParent();
            }
            if (alreadyInAResourceFolder || resource.getType() != 1 || !resource.getName().endsWith(".java")) {
                return !alreadyInAResourceFolder;
            }
            IFile javaFile = (IFile)resource;
            InputStream stream = javaFile.getContents();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String packageLine = null;
            do {
                try {
                    packageLine = reader.readLine();
                }
                catch (IOException ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.ui.importer.java", ex.getMessage(), (Throwable)ex));
                }
            } while (packageLine != null && !packageLine.startsWith(PACKAGE_KEYWORD));
            try {
                reader.close();
                stream.close();
            }
            catch (IOException iOException) {}
            if (packageLine != null) {
                packageLine = packageLine.substring(packageLine.indexOf(PACKAGE_KEYWORD) + PACKAGE_KEYWORD.length() + 1, packageLine.length());
                packageLine = packageLine.substring(0, packageLine.indexOf(59));
                packageLine = packageLine.trim();
                IContainer rootPackage = resource.getParent();
                if (!packageLine.isEmpty()) {
                    String[] segments;
                    String[] stringArray = segments = packageLine.split("\\.");
                    int n = segments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        rootPackage = rootPackage.getParent();
                        ++n2;
                    }
                }
                this.mostLikelySourceFolders.add(rootPackage);
            }
            return false;
        }

        public Set<IContainer> getSourceFolders() {
            return this.mostLikelySourceFolders;
        }
    }
}

