/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import tern.ITernProject;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.IIDETernScriptPathReporter;
import tern.eclipse.ide.core.utils.PathUtils;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.scriptpath.EclipsePathAdapter;
import tern.eclipse.ide.internal.core.scriptpath.IIDETernScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.ScriptResourceProxyVisitor;
import tern.scriptpath.ITernScriptPath;
import tern.scriptpath.ITernScriptResource;
import tern.scriptpath.impl.ContainerTernScriptPath;

public class FolderScriptPath
extends ContainerTernScriptPath
implements IIDETernScriptPath {
    private final IContainer container;
    private final IIDETernScriptPathReporter reporter;

    public FolderScriptPath(ITernProject project, IContainer container, String[] inclusionPatterns, String[] exclusionPatterns, String external) {
        super(project, ITernScriptPath.ScriptPathsType.FOLDER, inclusionPatterns, exclusionPatterns, external);
        this.container = container;
        this.reporter = ((IIDETernProject)project).getScriptPathReporter();
    }

    public List<ITernScriptResource> getScriptResources() {
        ArrayList<ITernScriptResource> resources = new ArrayList<ITernScriptResource>();
        ScriptResourceProxyVisitor visitor = new ScriptResourceProxyVisitor(this, resources, this.reporter);
        try {
            if (this.container.exists()) {
                this.container.accept((IResourceProxyVisitor)visitor, 0);
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while retrieving script resources from the folder script path " + this.container.getName(), e);
        }
        return resources;
    }

    public String getLabel() {
        StringBuilder text = new StringBuilder(this.container.getName()).append(" - ").append(this.container.getFullPath().makeRelative().toString());
        if (this.getExternalLabel() != null) {
            text.append(" (").append(this.getExternalLabel()).append(")");
        }
        return text.toString();
    }

    public String getPath() {
        return this.container.getProjectRelativePath().toString();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IContainer.class || clazz == IResource.class || clazz == IFolder.class) {
            return this.container;
        }
        if (clazz == IProject.class && this.container instanceof IProject) {
            return this.container;
        }
        return null;
    }

    public int hashCode() {
        return super.hashCode() * 17 + this.container.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FolderScriptPath) {
            return super.equals(obj) && this.container.equals((Object)((FolderScriptPath)obj).container);
        }
        return false;
    }

    @Override
    public boolean isBelongToContainer(IPath path) {
        IPath folderPath = this.getFullPath();
        return PathUtils.isBelongToContainer(path, folderPath);
    }

    @Override
    public boolean isInScope(IPath path, int resourceType) {
        IPath folderPath = this.getFullPath();
        IPath relativePath = PathUtils.getRelativePath(path, folderPath, resourceType);
        return this.isInScope(relativePath, EclipsePathAdapter.INSTANCE);
    }

    public IPath getFullPath() {
        return this.container.getFullPath();
    }
}

