/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tern.ITernFile;
import tern.ITernProject;
import tern.TernResourcesManager;
import tern.resources.AbstractTernFile;
import tern.utils.IOUtils;

public class IDETernFile
extends AbstractTernFile
implements ITernFile {
    private IFile iFile;

    public IDETernFile(IFile file) {
        this.iFile = file;
    }

    public String getFullName(ITernProject project) {
        IProject ip = (IProject)project.getAdapter(IProject.class);
        if (this.iFile.getProject().equals((Object)ip)) {
            return this.iFile.getProjectRelativePath().toString();
        }
        return "project://" + this.iFile.getFullPath().makeRelative().toString();
    }

    public String getFileName() {
        return this.iFile.getName();
    }

    public String getFileExtension() {
        return this.iFile.getFileExtension();
    }

    public ITernFile getRelativeFile(String relativePath) {
        IContainer parent = this.iFile.getParent();
        IFile relativeFile = parent.getFile((IPath)new Path(relativePath));
        if (relativeFile != null && relativeFile.exists()) {
            return TernResourcesManager.getTernFile((Object)relativeFile);
        }
        File rf = new File(parent.getLocation().toFile(), relativePath);
        if (rf.isFile()) {
            return TernResourcesManager.getTernFile((Object)rf);
        }
        return null;
    }

    public String getContents() throws IOException {
        String string;
        InputStream input = this.iFile.getContents();
        try {
            string = IOUtils.toString((InputStream)input, (String)this.iFile.getCharset());
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
        input.close();
        return string;
    }

    public Object getAdapter(Class adapterClass) {
        IPath path;
        if (adapterClass == IFile.class || adapterClass == IResource.class) {
            return this.iFile;
        }
        if (adapterClass == File.class && (path = this.iFile.getLocation()) != null) {
            return path.toFile();
        }
        return null;
    }

    public String toString() {
        return this.iFile.getFullPath().toString();
    }

    public boolean isAccessible() {
        return this.iFile.isAccessible();
    }

    public IFile getFile() {
        return this.iFile;
    }
}

