/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.core.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import tern.eclipse.ide.core.utils.ILineOfOffsetProvider;

public class FileUtils {
    private static ILineOfOffsetProvider provider;

    public static void setProvider(ILineOfOffsetProvider provider) {
        FileUtils.provider = provider;
    }

    public static ILineOfOffsetProvider getProvider() {
        return provider;
    }

    public static String getLineSeparator(IProject project) {
        if (Platform.isRunning()) {
            IScopeContext[] scopeContext;
            String lineSeparator = null;
            if (project != null) {
                scopeContext = new IScopeContext[]{new ProjectScope(project)};
                lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
                if (lineSeparator != null) {
                    return lineSeparator;
                }
            }
            scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        return System.getProperty("line.separator");
    }

    public static Integer getLineOfOffset(int start, IFile file) {
        if (FileUtils.getProvider() != null) {
            return FileUtils.getProvider().getLineOfOffset(start, file);
        }
        return null;
    }

    public static boolean isValidResource(IResource resource) {
        return resource != null && !resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.';
    }
}

