/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.Trace;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllerEnvironment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerProfileInitializer;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;

public class ServerProfileModel {
    public static final String SERVER_PROFILE_PROPERTY_KEY = "org.jboss.ide.eclipse.as.core.server.serverMode";
    private static final String LEGACY_MODE_KEY = "org.jboss.ide.eclipse.as.core.server.serverMode";
    public static final String DEFAULT_SERVER_PROFILE = "local";
    private static ServerProfileModel profileModel;
    private InternalProfileModel internal;
    ProfileErrorLogger logger = new ProfileErrorLogger();

    public static String getProfile(IServerAttributes server) {
        return ServerProfileModel.getProfile(server, DEFAULT_SERVER_PROFILE);
    }

    public static String getProfile(IServerAttributes server, String defaultProfile) {
        return server.getAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", server.getAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", defaultProfile));
    }

    public static void setProfile(IServerWorkingCopy wc, String profile) {
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", profile);
    }

    public static boolean isProfileKey(String key) {
        return "org.jboss.ide.eclipse.as.core.server.serverMode".equals(key);
    }

    public static ServerProfileModel getDefault() {
        if (profileModel == null) {
            profileModel = new ServerProfileModel();
        }
        return profileModel;
    }

    private ServerProfileModel() {
        this.internal = new InternalProfileModel();
        this.internal.load();
    }

    public void logMissingProfile(IServer server, String profileId) {
        this.logger.logMissingProfile(server, profileId);
    }

    public boolean profileRequiresRuntime(String serverType, String profile) {
        Trace.trace("/finer", "Checking if profile " + profile + " for server type " + serverType + " requires a runtime");
        String[] systems = SubsystemModel.getInstance().getAllSystemsForServertype(serverType);
        ServerProfile sp = this.internal.getProfile(profile, serverType);
        int i = 0;
        while (i < systems.length) {
            block6: {
                SubsystemModel.SubsystemMapping oneMapping = sp.getControllerMapping(serverType, systems[i], null);
                if (oneMapping == null) {
                    oneMapping = SubsystemModel.getInstance().getSubsystemMappingForCreation(serverType, systems[i], null, null, null);
                }
                if (oneMapping == null || oneMapping.getSubsystem() == null) break block6;
                if (oneMapping.getSubsystem().requiresRuntime()) {
                    Trace.trace("/finer", "Profile " + profile + " for server type " + serverType + " requires a runtime");
                    return true;
                }
            }
            try {
                Trace.trace("/finer", "Profile " + profile + " for server type " + serverType + " cannot find a subsystem for system " + systems[i]);
            }
            catch (CoreException coreException) {
                Trace.trace("/finer", "Non-critical error searching for a subsystem for system " + systems[i] + ", profile " + profile + ", and server type " + serverType);
            }
            ++i;
        }
        Trace.trace("/finer", "Profile " + profile + " for server type " + serverType + " does not require a runtime");
        return false;
    }

    public ServerProfile[] getProfiles(String serverType) {
        return this.internal.getProfiles(serverType);
    }

    public ServerProfile getProfile(String serverType, String id) {
        Trace.trace("/finer", "Locating server profile " + id + " for server type " + serverType);
        ServerProfile[] profiles = this.internal.getProfiles(serverType);
        if (profiles != null) {
            int i = 0;
            while (i < profiles.length) {
                if (profiles[i].getId().equals(id)) {
                    Trace.trace("/finer", "Server profile " + id + " for server type " + serverType + " found.");
                    return profiles[i];
                }
                ++i;
            }
        }
        Trace.trace("/finer", "Server profile " + id + " for server type " + serverType + " not found.");
        return null;
    }

    public IServerProfileInitializer[] getInitializers(String serverType, String profile) {
        ServerProfile sp = this.internal.getProfile(profile, serverType);
        return sp == null ? new IServerProfileInitializer[]{} : sp.getInitializers();
    }

    public ISubsystemController getController(IServer server, String profile, String system, ControllerEnvironment environment) throws CoreException {
        String serverType = server.getServerType().getId();
        Trace.trace("/finer", "Locating subsystem controller for profile " + profile + " for server type " + serverType + " and system " + system);
        ServerProfile sp = this.internal.getProfile(profile, serverType);
        if (sp != null) {
            try {
                ISubsystemController controller = sp.getController(server, system, environment);
                if (controller != null) {
                    return controller;
                }
            }
            catch (CoreException ce) {
                ASWTPToolsPlugin.log(ce.getStatus());
            }
        }
        return SubsystemModel.getInstance().createSubsystemController((IServerAttributes)server, system, environment == null ? null : environment.getMap());
    }

    private static class InitializerWrapper {
        private boolean failed = false;
        private IConfigurationElement element;
        private IServerProfileInitializer initializer;

        public InitializerWrapper(IConfigurationElement element) {
            this.element = element;
        }

        public IServerProfileInitializer getInitializer() {
            if (this.initializer == null && !this.failed) {
                try {
                    this.initializer = (IServerProfileInitializer)this.element.createExecutableExtension("class");
                }
                catch (CoreException ce) {
                    this.failed = true;
                    ASWTPToolsPlugin.log(ce);
                }
            }
            return this.initializer;
        }
    }

    private static class InternalProfileModel {
        private HashMap<String, HashMap<String, ServerProfile>> model = null;

        public void load() {
            this.model = new HashMap();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.wtp.core", "serverProfile");
            int i = 0;
            while (i < cf.length) {
                String name = cf[i].getName();
                if ("serverProfile".equals(name)) {
                    String id = cf[i].getAttribute("id");
                    String serverTypes = cf[i].getAttribute("serverTypes");
                    String[] typesSplit = serverTypes.split(",");
                    int j = 0;
                    while (j < typesSplit.length) {
                        ServerProfile sp = this.getOrCreateProfile(id, typesSplit[j]);
                        try {
                            sp.addConfigurationElement(cf[i]);
                        }
                        catch (CoreException ce) {
                            ASWTPToolsPlugin.log(ce);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private ServerProfile getOrCreateProfile(String profile, String serverType) {
            ServerProfile p;
            HashMap<String, ServerProfile> m = this.model.get(serverType);
            if (m == null) {
                m = new HashMap();
                this.model.put(serverType, m);
            }
            if ((p = m.get(profile)) == null) {
                p = new ServerProfile(profile, serverType);
                m.put(profile, p);
            }
            return p;
        }

        private ServerProfile getProfile(String profile, String serverType) {
            HashMap<String, ServerProfile> m = this.model.get(serverType);
            if (m != null) {
                ServerProfile ret = m.get(profile);
                return ret;
            }
            return null;
        }

        private ServerProfile[] getProfiles(String serverType) {
            HashMap<String, ServerProfile> m = this.model.get(serverType);
            if (m != null) {
                Collection<ServerProfile> profiles = m.values();
                return profiles.toArray(new ServerProfile[profiles.size()]);
            }
            return new ServerProfile[0];
        }
    }

    private static class ProfileErrorLogger {
        HashMap<String, HashMap<String, Boolean>> missingProfileErrors = new HashMap();

        private ProfileErrorLogger() {
        }

        public void logMissingProfile(IServer server, String profileId) {
            Boolean logged;
            HashMap<String, Boolean> profileMap;
            String serverType = server.getServerType().getId();
            if (this.missingProfileErrors.get(serverType) == null) {
                this.missingProfileErrors.put(serverType, new HashMap());
            }
            if ((profileMap = this.missingProfileErrors.get(serverType)).get(profileId) == null) {
                profileMap.put(profileId, false);
            }
            if (!(logged = profileMap.get(profileId)).booleanValue()) {
                String msg = "Server " + server.getName() + " (and all servers of type " + serverType + ") is unable to locate profile " + profileId + ". Your installation is missing functionality or dependencies.";
                Status status = new Status(4, "org.jboss.ide.eclipse.as.wtp.core", msg);
                ASWTPToolsPlugin.getDefault();
                ASWTPToolsPlugin.log((IStatus)status);
                profileMap.put(profileId, new Boolean(true));
            }
        }
    }

    public static class ServerProfile {
        private HashMap<String, String> subsystems = new HashMap();
        private ArrayList<InitializerWrapper> initializers = new ArrayList();
        private String id;
        private String serverType;
        private String visibleName;
        private String description;

        public ServerProfile(String id, String serverType) {
            this.id = id;
            this.serverType = serverType;
        }

        public String getId() {
            return this.id;
        }

        public String getServerType() {
            return this.serverType;
        }

        protected void setDescription(String desc) {
            this.description = desc;
        }

        protected void setVisibleName(String name) {
            this.visibleName = name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVisibleName() {
            return this.visibleName;
        }

        private void addConfigurationElement(IConfigurationElement el) throws CoreException {
            IConfigurationElement[] initializers = el.getChildren("initializer");
            int i = 0;
            while (i < initializers.length) {
                this.addInitializer(initializers[i]);
                ++i;
            }
            IConfigurationElement[] subsystems = el.getChildren("subsystem");
            int i2 = 0;
            while (i2 < subsystems.length) {
                this.addSystemMapping(subsystems[i2]);
                ++i2;
            }
            IConfigurationElement[] description = el.getChildren("description");
            if (description.length > 0) {
                if (description.length > 1 || this.description != null || this.visibleName != null) {
                    String id = el.getAttribute("id");
                    throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Multiple descriptions declared for profile id " + id + " and server type " + this.serverType));
                }
                String name = description[0].getAttribute("name");
                String desc = description[0].getAttribute("description");
                this.setVisibleName(name);
                this.setDescription(desc);
            }
        }

        protected IServerProfileInitializer[] getInitializers() {
            ArrayList<IServerProfileInitializer> valid = new ArrayList<IServerProfileInitializer>();
            for (InitializerWrapper wrapper : this.initializers) {
                if (wrapper.getInitializer() == null) continue;
                valid.add(wrapper.getInitializer());
            }
            return valid.toArray(new IServerProfileInitializer[valid.size()]);
        }

        private void addInitializer(IConfigurationElement el) {
            this.initializers.add(new InitializerWrapper(el));
        }

        private void addSystemMapping(IConfigurationElement el) throws CoreException {
            String system = el.getAttribute("system");
            String subsystem = el.getAttribute("subsystem");
            this.addSystemMapping(system, subsystem);
        }

        private void addSystemMapping(String system, String subsystem) throws CoreException {
            String val = this.subsystems.get(system);
            if (val != null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Multiple defaults set for profile " + this.id + " and system " + system + ". ids: " + subsystem + " and " + val));
            }
            this.subsystems.put(system, subsystem);
        }

        public ISubsystemController getController(IServer server, String system, ControllerEnvironment environment) throws CoreException {
            return this.getController(server, server.getServerType().getId(), system, environment);
        }

        public ISubsystemController getController(IServer server, String serverType, String system, ControllerEnvironment environment) throws CoreException {
            Map<String, Object> envMap = environment == null ? null : environment.getMap();
            String subsystem = this.subsystems.get(system);
            if (subsystem != null) {
                return SubsystemModel.getInstance().createControllerForSubsystem(server, serverType, system, subsystem, envMap);
            }
            return null;
        }

        public SubsystemModel.SubsystemMapping getControllerMapping(String serverType, String system, ControllerEnvironment environment) throws CoreException {
            Map<String, Object> envMap = environment == null ? null : environment.getMap();
            String subsystem = this.subsystems.get(system);
            if (subsystem != null) {
                return SubsystemModel.getInstance().getSubsystemMappingForCreation(serverType, system, null, subsystem, envMap);
            }
            return null;
        }
    }
}

