/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.modules.filter.patterns;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleResourceDelta;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;

public class ModulePathFilterUtility {
    private IModulePathFilter filter;

    public ModulePathFilterUtility(IModulePathFilter filter) {
        this.filter = filter;
    }

    public IModuleResource[] getCleanedMembers(IModule module) throws CoreException {
        return this.getCleanedChildren(ModuleResourceUtil.getMembers(module));
    }

    public IModuleResource[] getCleanedMembers(IModuleResource[] resources) {
        return this.getCleanedChildren(resources);
    }

    public IModuleResourceDelta[] getCleanedDelta(IModuleResourceDelta[] deltas) {
        if (deltas == null) {
            return new IModuleResourceDelta[0];
        }
        ArrayList<IModuleResourceDelta> collector = new ArrayList<IModuleResourceDelta>();
        int i = 0;
        while (i < deltas.length) {
            IModuleResourceDelta delta = this.cleanCloneDelta(deltas[i]);
            if (delta != null) {
                collector.add(delta);
            }
            ++i;
        }
        return collector.toArray(new IModuleResourceDelta[collector.size()]);
    }

    private IModuleResourceDelta cleanCloneDelta(IModuleResourceDelta delta) {
        IModuleResource r = delta.getModuleResource();
        if (this.filter.shouldInclude(r)) {
            IModuleResourceDelta[] children = delta.getAffectedChildren();
            IModuleResourceDelta[] cleanedChildren = this.getCleanedDelta(children);
            ModuleResourceDelta d = new ModuleResourceDelta(r, delta.getKind());
            d.setChildren(cleanedChildren);
            return d;
        }
        return null;
    }

    private IModuleResource[] getCleanedChildren(IModuleFolder parent) {
        return this.getCleanedChildren(parent.members());
    }

    private IModuleResource[] getCleanedChildren(IModuleResource[] children) {
        ArrayList<IModuleResource> cleaned = new ArrayList<IModuleResource>(children.length);
        IModuleResource tmp = null;
        int i = 0;
        while (i < children.length) {
            tmp = this.getCleanedResource(children[i]);
            if (tmp != null) {
                cleaned.add(tmp);
            }
            ++i;
        }
        return cleaned.toArray(new IModuleResource[cleaned.size()]);
    }

    private IModuleResource getCleanedResource(IModuleResource r) {
        if (r instanceof IModuleFile && this.filter.shouldInclude(r)) {
            return r;
        }
        if (r instanceof IModuleFolder && this.filter.shouldInclude(r)) {
            IModuleFolder o = (IModuleFolder)r;
            IContainer c = (IContainer)r.getAdapter(IContainer.class);
            ModuleFolder mf = new ModuleFolder(c, o.getName(), o.getModuleRelativePath());
            mf.setMembers(this.getCleanedChildren(o));
            return mf;
        }
        return null;
    }
}

