/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.IRole;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamJavaComponentDeclaration;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.text.ext.SeamExtPlugin;
import org.jboss.tools.seam.text.ext.hyperlink.SeamComponentHyperlink;

public class SeamComponentHyperlinkDetector
extends AbstractHyperlinkDetector {
    /*
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        int offset = region.getOffset();
        ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
        if (input == null) {
            return null;
        }
        if (input.getResource() == null || input.getResource().getProject() == null) {
            return null;
        }
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)input.getResource().getProject(), (boolean)true);
        if (seamProject == null) {
            return null;
        }
        SeamELCompletionEngine engine = new SeamELCompletionEngine();
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
        if (wordRegion == null) {
            return null;
        }
        IFile file = null;
        try {
            IResource resource = input.getCorrespondingResource();
            if (resource instanceof IFile) {
                file = (IFile)resource;
            }
        }
        catch (JavaModelException e) {
            SeamExtPlugin.getDefault().logError(e);
        }
        int[] nArray = new int[]{wordRegion.getOffset(), wordRegion.getOffset() + wordRegion.getLength()};
        IJavaElement[] elements = null;
        try {
            elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            if (elements == null) {
                return null;
            }
            if (elements.length != 1) {
                return null;
            }
            ArrayList<SeamComponentHyperlink> hyperlinks = new ArrayList<SeamComponentHyperlink>();
            if (elements[0] instanceof IAnnotatable) {
                Set vars;
                IAnnotatable annotatable = (IAnnotatable)elements[0];
                IAnnotation annotation = annotatable.getAnnotation("In");
                if (annotation == null || !annotation.exists()) {
                    return null;
                }
                String nameToSearch = elements[0].getElementName();
                IMemberValuePair[] mvPairs = annotation.getMemberValuePairs();
                if (mvPairs != null) {
                    IMemberValuePair[] iMemberValuePairArray = mvPairs;
                    int n = mvPairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name;
                        IMemberValuePair mvPair = iMemberValuePairArray[n2];
                        if ("value".equals(mvPair.getMemberName()) && mvPair.getValue() != null && (name = mvPair.getValue().toString()) != null && name.trim().length() != 0) {
                            nameToSearch = name;
                            break;
                        }
                        ++n2;
                    }
                }
                if (nameToSearch == null && nameToSearch.trim().length() == 0) {
                    return null;
                }
                ISeamJavaComponentDeclaration declaration = null;
                if (file != null) {
                    Set cs = seamProject.getComponentsByPath(file.getFullPath());
                    for (ISeamComponent c : cs) {
                        ISeamJavaComponentDeclaration d = c.getJavaDeclaration();
                        if (d == null || !file.getFullPath().equals((Object)d.getSourcePath()) || ((SeamJavaComponentDeclaration)d).getImports().isEmpty()) continue;
                        declaration = d;
                    }
                }
                if ((vars = seamProject.getVariables(declaration)) != null) {
                    for (ISeamContextVariable var : vars) {
                        IBijectedAttribute attr;
                        String resourceName;
                        if (!nameToSearch.equals(var.getName())) continue;
                        while (var instanceof ISeamContextShortVariable) {
                            var = ((ISeamContextShortVariable)var).getOriginal();
                        }
                        if (var == null) continue;
                        if (var instanceof ISeamXmlFactory) {
                            ISeamXmlFactory xmlFactory = (ISeamXmlFactory)var;
                            String value = xmlFactory.getValue();
                            if (value == null || value.trim().length() == 0) {
                                value = xmlFactory.getMethod();
                            }
                            if (value == null || value.trim().length() == 0) continue;
                            List javaElements = null;
                            try {
                                javaElements = engine.getJavaElementsForExpression(seamProject, file, value, region.getOffset());
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                SeamExtPlugin.getDefault().logError(e);
                            }
                            catch (BadLocationException e) {
                                SeamExtPlugin.getDefault().logError(e);
                            }
                            if (javaElements == null) continue;
                            for (IJavaElement javaElement : javaElements) {
                                String resourceName2 = null;
                                if (javaElement.getResource() != null) {
                                    resourceName2 = javaElement.getResource().getName();
                                }
                                hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName2, javaElement, nameToSearch));
                            }
                            continue;
                        }
                        if (var instanceof ISeamComponent) {
                            resourceName = null;
                            ISeamComponent comp = (ISeamComponent)var;
                            Set decls = comp.getAllDeclarations();
                            for (ISeamComponentDeclaration decl : decls) {
                                if (decl.getResource() == null) continue;
                                resourceName = decl.getResource().getName();
                                break;
                            }
                            hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName, (ISeamComponent)var, nameToSearch));
                            continue;
                        }
                        if (var instanceof IRole) {
                            resourceName = null;
                            if (var.getResource() != null) {
                                resourceName = var.getResource().getName();
                            }
                            hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName, (IRole)var, nameToSearch));
                            continue;
                        }
                        if (!(var instanceof IBijectedAttribute)) continue;
                        resourceName = null;
                        if (var.getResource() != null) {
                            resourceName = var.getResource().getName();
                        }
                        if ((attr = (IBijectedAttribute)var).getSourceMember() == null) continue;
                        hyperlinks.add(new SeamComponentHyperlink(wordRegion, resourceName, (IBijectedAttribute)var, nameToSearch));
                    }
                }
            }
            if (hyperlinks != null && !hyperlinks.isEmpty()) {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
        }
        catch (JavaModelException jme) {
            SeamExtPlugin.getDefault().logError(jme);
        }
        return null;
    }
}

