/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.ui.editor.contentassist.osgi;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.AbstractIdContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferenceIdContentAssistCalculator
extends AbstractIdContentAssistCalculator {
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        this.addBeanIdProposal(context, recorder);
    }

    private void addBeanIdProposal(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        this.createProposalsForClassName(context, recorder, BeansEditorUtils.getAttribute((Node)context.getNode(), (String)"interface"));
        NodeList children = context.getNode().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if ("interfaces".equals(child.getLocalName())) {
                NodeList valueChildren = child.getChildNodes();
                int j = 0;
                while (j < valueChildren.getLength()) {
                    Node valueChild = valueChildren.item(j);
                    if ("value".equals(valueChild.getLocalName())) {
                        NodeList textChildren = valueChild.getChildNodes();
                        int k = 0;
                        while (k < textChildren.getLength()) {
                            this.createProposalsForClassName(context, recorder, textChildren.item(k).getNodeValue());
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void createProposalsForClassName(IContentAssistContext context, IContentAssistProposalRecorder recorder, String className) {
        IType type;
        IFile file = context.getFile();
        if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null) {
            this.createBeanIdProposals(context, recorder, type.getFullyQualifiedName());
            Set allInterfaces = Introspector.getAllImplementedInterfaces((IType)type);
            for (IType interf : allInterfaces) {
                this.createBeanIdProposals(context, recorder, interf.getFullyQualifiedName());
            }
        }
    }
}

