/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.views;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.views.MergeResultsDecorator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MergeResultsViewLabelProvider
extends LabelProvider
implements IColorProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private CompareConfiguration compareConfiguration = new CompareConfiguration();
    private MergeResultsDecorator mergeResultsDecorator = new MergeResultsDecorator();

    public Image getImage(Object element) {
        if (element instanceof MergeOutput) {
            Image image = null;
            image = ((MergeOutput)element).isIncomplete() ? Activator.getImage("merge_aborted.gif") : (((MergeOutput)element).isAbnormalEnd() ? Activator.getImage("merge_output_abnormal.gif") : (((MergeOutput)element).isInProgress() ? Activator.getImage("merge_output_in_progress.gif") : Activator.getImage("merge_output.gif")));
            return this.compareConfiguration.getImage(image, 0);
        }
        if (element instanceof MergeResult) {
            MergeResult mergeResult = (MergeResult)element;
            if (mergeResult.getResource() == null || mergeResult.getResource().getName() == null) {
                return super.getImage(element);
            }
            return this.getImage(mergeResult);
        }
        if (element instanceof MergeResultsFolder) {
            MergeResultsFolder mergeResultsFolder = (MergeResultsFolder)element;
            Image image = mergeResultsFolder.getFolder().getFullPath().makeRelative().toString().length() > mergeResultsFolder.getRootFolderLength() ? this.workbenchLabelProvider.getImage((Object)mergeResultsFolder.getFolder()) : this.workbenchLabelProvider.getImage((Object)mergeResultsFolder.getMergeOutput().getResource());
            MergeResult mergeResult = mergeResultsFolder.getMergeResult();
            if (mergeResult != null) {
                return this.getImage(mergeResult);
            }
            return this.compareConfiguration.getImage(image, 0);
        }
        return super.getImage(element);
    }

    private Image getImage(MergeResult mergeResult) {
        Image image = null;
        image = !mergeResult.getResource().exists() && mergeResult.getResource().getName().indexOf(".") == -1 ? this.workbenchLabelProvider.getImage((Object)ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(mergeResult.getPath()))) : this.workbenchLabelProvider.getImage((Object)mergeResult.getResource());
        if (mergeResult.getAction() != null && mergeResult.getAction().trim().length() > 0) {
            if (mergeResult.getAction().equals("U")) {
                image = this.mergeResultsDecorator.getImage(image, 1);
            } else if (mergeResult.getAction().equals("A")) {
                image = this.mergeResultsDecorator.getImage(image, 0);
            } else if (mergeResult.getAction().equals("D")) {
                image = this.mergeResultsDecorator.getImage(image, 2);
            } else if (mergeResult.getAction().equals("C")) {
                image = mergeResult.isResolved() ? this.mergeResultsDecorator.getImage(image, 3) : this.mergeResultsDecorator.getImage(image, 4);
            } else if (mergeResult.getAction().equals("G")) {
                image = this.mergeResultsDecorator.getImage(image, 1);
            } else if (mergeResult.getAction().equals("S")) {
                image = this.compareConfiguration.getImage(image, 0);
            }
        }
        if (mergeResult.getPropertyAction() != null && mergeResult.getPropertyAction().trim().length() > 0) {
            if (mergeResult.getPropertyAction().equals("U")) {
                image = this.mergeResultsDecorator.getImage(image, 9);
            } else if (mergeResult.getPropertyAction().equals("A")) {
                image = this.mergeResultsDecorator.getImage(image, 8);
            } else if (mergeResult.getPropertyAction().equals("D")) {
                image = this.mergeResultsDecorator.getImage(image, 10);
            } else if (mergeResult.getPropertyAction().equals("C")) {
                image = mergeResult.isPropertyResolved() ? this.mergeResultsDecorator.getImage(image, 3) : this.mergeResultsDecorator.getImage(image, 12);
            } else if (mergeResult.getPropertyAction().equals("G")) {
                image = this.mergeResultsDecorator.getImage(image, 9);
            }
        }
        if (mergeResult.hasTreeConflict()) {
            image = mergeResult.isTreeConflictResolved() ? this.mergeResultsDecorator.getImage(image, 3) : this.mergeResultsDecorator.getImage(image, 14);
        }
        return image;
    }

    public String getText(Object element) {
        MergeResult mergeResult;
        int mode = this.store.getInt("MergeResultsView_layout");
        if (element instanceof MergeOutput) {
            MergeOutput mergeOutput = (MergeOutput)element;
            if (mergeOutput.getDescription() == null) {
                if (mergeOutput.getResource() == null) {
                    return "";
                }
                return mergeOutput.getResource().getFullPath().makeRelative().toOSString();
            }
            return mergeOutput.getDescription();
        }
        if (element instanceof MergeResultsFolder) {
            MergeResultsFolder folder = (MergeResultsFolder)element;
            return folder.toString();
        }
        if (element instanceof MergeResult && (mergeResult = (MergeResult)element).getResource() != null && mergeResult.getResource().getName() != null) {
            if (mode == 1 && mergeResult.getResource().getFullPath() != null) {
                return String.valueOf(mergeResult.getResource().getName()) + " - " + mergeResult.getResource().getFullPath().toString();
            }
            return mergeResult.getResource().getName();
        }
        return super.getText(element);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        MergeResultsFolder mergeResultsFolder;
        MergeResult mergeResult;
        MergeResult mergeResult2;
        if (element instanceof MergeResult && (mergeResult2 = (MergeResult)element).getAction().equals("S")) {
            return Display.getDefault().getSystemColor(15);
        }
        if (element instanceof MergeResultsFolder && (mergeResult = (mergeResultsFolder = (MergeResultsFolder)element).getMergeResult()) != null && mergeResult.getAction().equals("S")) {
            return Display.getDefault().getSystemColor(15);
        }
        return null;
    }
}

