/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class UndoMergeCommand
implements ISVNCommand {
    private final IResource resource;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public UndoMergeCommand(IResource resource) {
        this.resource = resource;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNRepositoryLocation repository;
        ISVNClientAdapter svnClient;
        block10: {
            svnClient = null;
            repository = null;
            try {
                try {
                    OperationManager operationManager = OperationManager.getInstance();
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
                    repository = svnResource.getRepository();
                    svnClient = repository.getSVNClient();
                    svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                    operationManager.beginOperation(svnClient);
                    LocalResourceStatus status = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource).getStatus();
                    if (!status.isManaged()) {
                        try {
                            this.resource.delete(true, monitor);
                            break block10;
                        }
                        catch (CoreException ex) {
                            throw SVNException.wrapException((CoreException)ex);
                        }
                    }
                    File path = this.resource.getLocation().toFile();
                    svnClient.revert(path, true);
                    if (this.resource.getType() != 1) {
                        operationManager.onNotify(path, SVNNodeKind.UNKNOWN);
                    }
                    monitor.worked(100);
                }
                catch (SVNClientException e) {
                    throw SVNException.wrapException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                if (repository != null) {
                    repository.returnSVNClient(svnClient);
                }
                OperationManager.getInstance().endOperation(true, this.operationResourceCollector.getOperationResources());
                monitor.done();
                throw throwable;
            }
        }
        if (repository != null) {
            repository.returnSVNClient(svnClient);
        }
        OperationManager.getInstance().endOperation(true, this.operationResourceCollector.getOperationResources());
        monitor.done();
    }
}

