/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.mylyn.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowContextStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "spring/webflow";

    public boolean acceptsObject(Object object) {
        return object instanceof IWebflowModelElement || object instanceof IWebflowProject || object instanceof ISpringProject || object instanceof IResource && WebflowModelUtils.isWebflowConfig((IResource)((IResource)object));
    }

    public boolean canBeLandmark(String handle) {
        return true;
    }

    public boolean canFilter(Object obj) {
        AbstractContextStructureBridge parentBridge;
        if (obj instanceof IModelElement) {
            IModelElement[] children;
            IModelElement modelElement = (IModelElement)obj;
            IModelElement[] iModelElementArray = children = modelElement.getElementChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                IInteractionElement node = ContextCore.getContextManager().getElement(this.getHandleIdentifier(child));
                if (node != null && node.getInterest().isInteresting()) {
                    return false;
                }
                ++n2;
            }
            if (modelElement instanceof ISpringProject) {
                IProject project = ((ISpringProject)modelElement).getProject();
                IWebflowProject webflowProject = Activator.getModel().getProject(project);
                return this.canFilter(webflowProject);
            }
            IInteractionElement node = ContextCore.getContextManager().getElement(this.getHandleIdentifier(obj));
            if (node != null && node.getInterest().isInteresting()) {
                return false;
            }
        } else if (obj instanceof IFile && WebflowModelUtils.isWebflowConfig((IResource)((IResource)obj))) {
            return this.canFilter(WebflowModelUtils.getWebflowConfig((IFile)((IFile)obj)));
        }
        return (parentBridge = ContextCore.getStructureBridge((String)this.parentContentType)) == null || parentBridge.canFilter(obj);
    }

    public List<String> getChildHandles(String handle) {
        Object obj = this.getObjectForHandle(handle);
        if (obj != null && obj instanceof IModelElement) {
            IModelElement[] children;
            ArrayList<String> childHandles = new ArrayList<String>();
            IModelElement[] iModelElementArray = children = ((IModelElement)obj).getElementChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                childHandles.add(child.getElementID());
                ++n2;
            }
            return childHandles;
        }
        return Collections.emptyList();
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String handle) {
        Object obj = this.getObjectForHandle(handle);
        if (obj instanceof IModelElement) {
            return CONTENT_TYPE;
        }
        return "resource";
    }

    public String getHandleIdentifier(Object obj) {
        if (obj instanceof IModelElement) {
            return ((IModelElement)obj).getElementID();
        }
        if (obj instanceof IFile && WebflowModelUtils.isWebflowConfig((IResource)((IFile)obj))) {
            return WebflowModelUtils.getWebflowConfig((IFile)((IFile)obj)).getElementID();
        }
        return null;
    }

    public String getLabel(Object obj) {
        if (obj instanceof IModelElement) {
            return ((IModelElement)obj).getElementName();
        }
        if (obj instanceof IFile && WebflowModelUtils.isWebflowConfig((IResource)((IFile)obj))) {
            return WebflowModelUtils.getWebflowConfig((IFile)((IFile)obj)).getElementName();
        }
        return null;
    }

    public Object getObjectForHandle(String handle) {
        AbstractContextStructureBridge parentBridge;
        Object obj = null;
        if (handle != null) {
            obj = Activator.getModel().getElement(handle);
            if (obj != null) {
                return obj;
            }
            obj = SpringCore.getModel().getElement(handle);
            if (obj != null) {
                return obj;
            }
        }
        if ((parentBridge = ContextCore.getStructureBridge((String)this.parentContentType)) != null) {
            obj = parentBridge.getObjectForHandle(handle);
        }
        return null;
    }

    public String getParentHandle(String handle) {
        Object obj = this.getObjectForHandle(handle);
        if (obj instanceof IWebflowProject) {
            ISpringProject project = SpringCore.getModel().getProject(((IWebflowProject)obj).getProject());
            if (project != null) {
                return project.getElementID();
            }
        } else if (obj instanceof ISpringProject) {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            if (parentBridge != null && parentBridge instanceof ResourceStructureBridge) {
                return parentBridge.getHandleIdentifier((Object)((ISpringProject)obj).getProject());
            }
        } else if (obj != null && obj instanceof IModelElement) {
            IModelElement parent = ((IModelElement)obj).getElementParent();
            if (parent != null) {
                return parent.getElementID();
            }
        } else {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            if (parentBridge != null && parentBridge instanceof ResourceStructureBridge) {
                return parentBridge.getParentHandle(handle);
            }
        }
        return null;
    }

    public boolean isDocument(String handle) {
        Object obj = this.getObjectForHandle(handle);
        return obj != null && obj instanceof IWebflowConfig;
    }

    public String getHandleForOffsetInObject(Object arg0, int arg1) {
        return null;
    }
}

