/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.boot.properties.editor.completions.ProposalApplier;

public class DocumentEdits
implements ProposalApplier {
    private static final OffsetTransformer NULL_TRANSFORM = new OffsetTransformer(){

        @Override
        public int trasform(int offset) {
            return offset;
        }
    };
    private ArrayList<Edit> edits = new ArrayList();
    private IDocument doc;

    public DocumentEdits(IDocument doc) {
        this.doc = doc;
    }

    public void delete(int start, int end) {
        Assert.isLegal((start <= end ? 1 : 0) != 0);
        this.edits.add(new Deletion(start, end));
    }

    public void delete(int offset, String text) {
        this.delete(offset, offset + text.length());
    }

    public void insert(int offset, String insert) {
        this.edits.add(new Insertion(offset, insert));
    }

    @Override
    public Point getSelection(IDocument doc) throws Exception {
        DocumentState selectionState = new DocumentState(null);
        for (Edit edit : this.edits) {
            edit.apply(selectionState);
        }
        if (selectionState.selection >= 0) {
            return new Point(selectionState.selection, 0);
        }
        return null;
    }

    @Override
    public void apply(IDocument _doc) throws Exception {
        DocumentState doc = new DocumentState(_doc);
        for (Edit edit : this.edits) {
            edit.apply(doc);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DocumentModifier(\n");
        for (Edit edit : this.edits) {
            buf.append("   " + edit);
        }
        buf.append(")\n");
        return buf.toString();
    }

    public void moveCursorTo(int newCursor) {
        this.insert(newCursor, "");
    }

    public void deleteLineBackwardAtOffset(int offset) throws Exception {
        int line = this.doc.getLineOfOffset(offset);
        this.deleteLineBackward(line);
    }

    public void deleteLineBackward(int lineNumber) throws BadLocationException {
        int endOfDeletion;
        int startOfDeletion;
        IRegion line = this.doc.getLineInformation(lineNumber);
        if (lineNumber > 0) {
            IRegion previousLine = this.doc.getLineInformation(lineNumber - 1);
            startOfDeletion = this.endOf(previousLine);
            endOfDeletion = this.endOf(line);
        } else if (lineNumber < this.doc.getNumberOfLines() - 1) {
            IRegion nextLine = this.doc.getLineInformation(lineNumber + 1);
            startOfDeletion = line.getOffset();
            endOfDeletion = nextLine.getOffset();
        } else {
            startOfDeletion = line.getOffset();
            endOfDeletion = this.endOf(line);
        }
        this.delete(startOfDeletion, endOfDeletion);
    }

    private int endOf(IRegion line) {
        return line.getOffset() + line.getLength();
    }

    static /* synthetic */ OffsetTransformer access$0() {
        return NULL_TRANSFORM;
    }

    private class Deletion
    extends Edit {
        private int start;
        private int end;

        public Deletion(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        void apply(DocumentState doc) throws BadLocationException {
            doc.delete(this.start, this.end);
        }

        @Override
        public String toString() {
            return "del(" + this.start + "->" + this.end + ")";
        }
    }

    private static class DocumentState {
        private IDocument doc;
        private OffsetTransformer org2new = DocumentEdits.access$0();
        private int selection = -1;

        public DocumentState(IDocument doc) {
            this.doc = doc;
        }

        public void insert(int start, final String text) throws BadLocationException {
            final int tStart = this.org2new.trasform(start);
            if (!text.isEmpty()) {
                if (this.doc != null) {
                    this.doc.replace(tStart, 0, text);
                }
                final OffsetTransformer parent = this.org2new;
                this.org2new = new OffsetTransformer(){

                    @Override
                    public int trasform(int org) {
                        int tOffset = parent.trasform(org);
                        if (tOffset < tStart) {
                            return tOffset;
                        }
                        return tOffset + text.length();
                    }
                };
            }
            this.selection = tStart + text.length();
        }

        public void delete(final int start, int end) throws BadLocationException {
            int tEnd;
            final int tStart = this.org2new.trasform(start);
            if (end > start && (tEnd = this.org2new.trasform(end)) > tStart) {
                if (this.doc != null) {
                    this.doc.replace(tStart, tEnd - tStart, "");
                }
                final OffsetTransformer parent = this.org2new;
                this.org2new = new OffsetTransformer(){

                    @Override
                    public int trasform(int org) {
                        int tOffset = parent.trasform(org);
                        if (tOffset <= tStart) {
                            return tOffset;
                        }
                        if (tOffset >= tEnd) {
                            return tOffset - tEnd + tStart;
                        }
                        return start;
                    }
                };
            }
            this.selection = tStart;
        }

        public String toString() {
            if (this.doc == null) {
                return super.toString();
            }
            StringBuilder buf = new StringBuilder();
            buf.append("DocumentState(\n");
            buf.append(String.valueOf(this.doc.get()) + "\n");
            buf.append(")\n");
            return buf.toString();
        }
    }

    private abstract class Edit {
        private Edit() {
        }

        abstract void apply(DocumentState var1) throws BadLocationException;

        public abstract String toString();
    }

    private class Insertion
    extends Edit {
        private int offset;
        private String text;

        public Insertion(int offset, String insert) {
            this.offset = offset;
            this.text = insert;
        }

        @Override
        void apply(DocumentState doc) throws BadLocationException {
            doc.insert(this.offset, this.text);
        }

        @Override
        public String toString() {
            return "ins(" + this.text + "@" + this.offset + ")";
        }
    }

    private static interface OffsetTransformer {
        public int trasform(int var1);
    }
}

