/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesFileEditor;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconciler;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileStrategy;
import org.springframework.ide.eclipse.boot.properties.editor.util.ReconcilingUtil;

public abstract class SpringPropertiesReconcilerFactory {
    public SpringPropertiesReconciler createReconciler(ISourceViewer sourceViewer) {
        IReconcilingStrategy strategy = null;
        if (EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
            SpellingReconcileStrategy spellcheck = new SpellingReconcileStrategy(sourceViewer, EditorsUI.getSpellingService()){

                protected IContentType getContentType() {
                    return SpringPropertiesFileEditor.CONTENT_TYPE;
                }
            };
            strategy = ReconcilingUtil.compose(strategy, (IReconcilingStrategy)spellcheck);
        }
        try {
            IReconcileEngine reconcileEngine = this.createEngine();
            SpringPropertiesReconcileStrategy propertyChecker = new SpringPropertiesReconcileStrategy(sourceViewer, reconcileEngine);
            strategy = ReconcilingUtil.compose(strategy, propertyChecker);
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        if (strategy != null) {
            SpringPropertiesReconciler reconciler = new SpringPropertiesReconciler(strategy);
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    protected abstract IReconcileEngine createEngine() throws Exception;
}

