/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesHyperlinkDetector;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesInformationControlCreator;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesProposalProcessor;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconciler;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconcilerFactory;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesTextHover;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.util.HyperlinkDetectorUtil;

public class SpringPropertiesFileSourceViewerConfiguration
extends PropertiesFileSourceViewerConfiguration {
    private static final String DIALOG_SETTINGS_KEY = PropertiesFileSourceViewerConfiguration.class.getName();
    private SpringPropertiesCompletionEngine engine;
    private SpringPropertiesReconciler fReconciler;
    private SpringPropertiesReconcilerFactory fReconcilerFactory = new SpringPropertiesReconcilerFactory(){

        @Override
        protected IReconcileEngine createEngine() throws Exception {
            return new SpringPropertiesReconcileEngine(SpringPropertiesFileSourceViewerConfiguration.this.getEngine().getIndexProvider(), SpringPropertiesFileSourceViewerConfiguration.this.getEngine().getTypeUtil());
        }
    };

    public SpringPropertiesFileSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        try {
            SpringPropertiesCompletionEngine engine = this.getEngine();
            if (engine != null) {
                ContentAssistant a = new ContentAssistant();
                a.setDocumentPartitioning("___pf_partitioning");
                a.setContentAssistProcessor((IContentAssistProcessor)new SpringPropertiesProposalProcessor(this.getEngine()), "__dftl_partition_content_type");
                a.setContentAssistProcessor((IContentAssistProcessor)new SpringPropertiesProposalProcessor(this.getEngine()), "__pf_roperty_value");
                a.enableColoredLabels(true);
                a.enableAutoActivation(true);
                a.setInformationControlCreator((IInformationControlCreator)new SpringPropertiesInformationControlCreator(JavaPlugin.getAdditionalInfoAffordanceString()));
                SpringPropertiesFileSourceViewerConfiguration.setSorter(a);
                a.setRestoreCompletionProposalSize(this.getDialogSettings(sourceViewer, DIALOG_SETTINGS_KEY));
                return a;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return null;
    }

    private SpringPropertiesCompletionEngine getEngine() throws Exception {
        IJavaProject jp;
        ITextEditor editor;
        if (this.engine == null && (editor = this.getEditor()) != null && (jp = EditorUtility.getJavaProject((IEditorInput)this.getEditor().getEditorInput())) != null) {
            this.engine = new SpringPropertiesCompletionEngine(jp);
        }
        return this.engine;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 0);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        ITextHover delegate = super.getTextHover(sourceViewer, contentType, stateMask);
        try {
            SpringPropertiesCompletionEngine engine;
            if (contentType.equals("__dftl_partition_content_type") && (engine = this.getEngine()) != null) {
                return new SpringPropertiesTextHover(sourceViewer, engine, delegate);
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return delegate;
    }

    private IDialogSettings getDialogSettings(ISourceViewer sourceViewer, String dialogSettingsKey) {
        IDialogSettings existing = SpringPropertiesEditorPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (existing != null) {
            return existing;
        }
        IDialogSettings created = SpringPropertiesEditorPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        Rectangle windowBounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        int suggestW = (int)((double)windowBounds.width * 0.35);
        int suggestH = (int)((double)suggestW * 0.6);
        if (suggestW > 300) {
            created.put("size.x", suggestW);
            created.put("size.y", suggestH);
        }
        return created;
    }

    public static void setSorter(ContentAssistant a) {
        try {
            Class<?> sorterInterface = Class.forName("org.eclipse.jface.text.contentassist.ICompletionProposalSorter");
            Method m = ContentAssistant.class.getMethod("setSorter", sorterInterface);
            m.invoke((Object)a, PropertyCompletionFactory.SORTER);
        }
        catch (Throwable throwable) {}
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fReconciler == null) {
            this.fReconciler = this.fReconcilerFactory.createReconciler(sourceViewer);
        }
        return this.fReconciler;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        SpringPropertiesHyperlinkDetector myDetector = null;
        try {
            myDetector = new SpringPropertiesHyperlinkDetector(this.getEngine());
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return HyperlinkDetectorUtil.merge(super.getHyperlinkDetectors(sourceViewer), (IHyperlinkDetector)myDetector);
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map superTargets = super.getHyperlinkDetectorTargets(sourceViewer);
        superTargets.remove("org.eclipse.jdt.ui.PropertiesFileEditor");
        return superTargets;
    }

    public void forceReconcile() {
        if (this.fReconciler != null) {
            this.fReconciler.forceReconcile();
        }
    }
}

