/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.core.client;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.eclipse.internal.core.AtlassianCorePlugin;
import com.atlassian.theplugin.commons.exception.HttpProxySettingsException;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;

public class HttpSessionCallbackImpl
implements HttpSessionCallback {
    private final String userAgent;
    private final Map<ConnectionCfg, HttpClient> httpClients = new HashMap<ConnectionCfg, HttpClient>();
    private final Map<String, ConnectionCfg> locations = new HashMap<String, ConnectionCfg>();

    public HttpSessionCallbackImpl() {
        this.userAgent = "Atlassian Connector for Eclipse/" + AtlassianCorePlugin.getDefault().getVersion();
    }

    public synchronized HttpClient getHttpClient(ConnectionCfg server) throws HttpProxySettingsException {
        HttpClient httpClient = this.httpClients.get(server);
        assert (httpClient != null);
        httpClient.getParams().setParameter("http.useragent", (Object)this.userAgent);
        return httpClient;
    }

    public void configureHttpMethod(AbstractHttpSession session, HttpMethod method) {
    }

    public synchronized void removeClient(ConnectionCfg server) {
        HttpClient client = this.httpClients.remove(server);
        if (client != null) {
            this.shutdown(client);
        }
    }

    public synchronized void removeClient(AbstractWebLocation location) {
        ConnectionCfg server = this.locations.remove(location.getUrl());
        if (server != null) {
            this.removeClient(server);
        }
    }

    public synchronized void updateHostConfiguration(AbstractWebLocation location, ConnectionCfg serverCfg) {
        HttpClient httpClient = this.httpClients.get(serverCfg);
        if (httpClient == null) {
            httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            this.httpClients.put(serverCfg, httpClient);
            this.locations.put(location.getUrl(), serverCfg);
            WebUtil.addConnectionManager((HttpConnectionManager)httpClient.getHttpConnectionManager());
        }
        this.setupHttpClient(location, httpClient);
    }

    private void setupHttpClient(AbstractWebLocation location, HttpClient httpClient) {
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)httpClient, (AbstractWebLocation)location, (IProgressMonitor)new NullProgressMonitor());
        httpClient.setHostConfiguration(hostConfiguration);
        AuthenticationCredentials proxyCredentials = location.getCredentials(AuthenticationType.PROXY);
        if (proxyCredentials != null && proxyCredentials.getUserName() != null && proxyCredentials.getUserName().contains("\\")) {
            httpClient.getParams().setAuthenticationPreemptive(false);
            StatusHandler.log((IStatus)new Status(1, "com.atlassian.connector.eclipse.core", "NTLM proxy detected. Preemptive authentication disabled."));
        } else {
            httpClient.getParams().setAuthenticationPreemptive(true);
        }
    }

    protected void finalize() throws Throwable {
        for (HttpClient httpClient : this.httpClients.values()) {
            this.shutdown(httpClient);
        }
        this.httpClients.clear();
    }

    public void shutdown(HttpClient httpClient) {
        HttpConnectionManager mgr = httpClient.getHttpConnectionManager();
        WebUtil.removeConnectionManager((HttpConnectionManager)mgr);
        ((MultiThreadedHttpConnectionManager)mgr).shutdown();
    }

    public void clear() {
        this.locations.clear();
        this.httpClients.clear();
    }

    public void disposeClient(ConnectionCfg server) {
        this.removeClient(server);
    }

    public Cookie[] getCookiesHeaders(ConnectionCfg server) {
        try {
            return this.getHttpClient(server).getState().getCookies();
        }
        catch (HttpProxySettingsException httpProxySettingsException) {
            return new Cookie[0];
        }
    }
}

