/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.ui.wizards.Messages;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;

public class InterfaceTableContentProvider
implements ITreeContentProvider {
    private final IFile file;
    private final IDOMDocument document;

    public InterfaceTableContentProvider(IFile file, IDOMDocument document) {
        this.file = file;
        this.document = document;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<IType> types = new ArrayList<IType>();
        if (inputElement instanceof Text) {
            String ref = ((Text)inputElement).getText();
            String className = BeansEditorUtils.getClassNameForBean((IFile)this.file, (Document)this.document, (String)ref);
            IType type = JdtUtils.getJavaType((IProject)this.file.getProject(), (String)className);
            if (type != null) {
                types.add(type);
                try {
                    ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
                    IType[] interfaces = hierarchy.getAllSuperInterfaces(type);
                    types.addAll(Arrays.asList(interfaces));
                }
                catch (JavaModelException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("InterfaceTableContentProvider.ERROR_CONTENT_PROVIDER_DATA"), (Throwable)e));
                }
            }
        }
        return types.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

