/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.namespaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionListener;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.ui.ConfigUiPlugin;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigLabelProvider;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterPart;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigContentProvider;
import org.springframework.ide.eclipse.config.ui.editors.namespaces.Messages;
import org.springframework.ide.eclipse.config.ui.editors.namespaces.NamespacesLabelProvider;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespacesMasterPart
extends AbstractConfigMasterPart
implements INamespaceDefinitionListener {
    private Element rootElement;
    private volatile List<INamespaceDefinition> namespaceDefinitionList = new CopyOnWriteArrayList<INamespaceDefinition>();
    private volatile boolean loading = false;
    private final Set<INamespaceDefinition> selectedNamespaces = new HashSet<INamespaceDefinition>();
    private final Map<INamespaceDefinition, String> selectedVersions = new HashMap<INamespaceDefinition, String>();
    private CheckboxTableViewer xsdViewer;
    private CheckStateListener checkListener;
    private final ShallowFormatProcessorXML formatProcessor = new ShallowFormatProcessorXML();
    private final CountDownLatch lazyInitializationLatch = new CountDownLatch(1);

    public NamespacesMasterPart(AbstractConfigFormPage page, Composite parent) {
        super(page, parent);
        BeansCorePlugin.registerNamespaceDefinitionListener((INamespaceDefinitionListener)this);
        this.getNamespaceDefinitionList();
    }

    protected void addXsdDefinition(INamespaceDefinition definition) {
        if (!this.existsInConfiguration(definition)) {
            StructuredTextViewer textView = this.getConfigEditor().getTextViewer();
            IDOMDocument doc = this.getConfigEditor().getDomDocument();
            doc.getModel().beginRecording((Object)textView);
            if (this.rootElement == null) {
                this.rootElement = doc.createElement(BeansSchemaConstants.ELEM_BEANS);
                doc.appendChild((Node)this.rootElement);
                INamespaceDefinition defNamespace = NamespaceUtils.getDefaultNamespaceDefinition();
                if (defNamespace != null) {
                    if (!this.xsdViewer.getChecked((Object)defNamespace)) {
                        this.xsdViewer.setChecked((Object)defNamespace, true);
                    }
                    this.rootElement.setAttribute(ConfigCoreUtils.ATTR_DEFAULT_NAMESPACE, defNamespace.getNamespaceURI());
                }
                this.rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
            if (!this.existsInConfiguration(definition)) {
                this.rootElement.setAttribute(String.valueOf(ConfigCoreUtils.ATTR_NAMESPACE_PREFIX) + definition.getNamespacePrefix((IResource)this.getConfigEditor().getResourceFile()), definition.getNamespaceURI());
            }
            this.selectedNamespaces.add(definition);
            this.updateXsdVersion();
            doc.getModel().endRecording((Object)textView);
        }
    }

    private String attributeNameToPrefix(String attributeName, String uri) {
        int colonIndex = attributeName.indexOf(":");
        if (attributeName.length() > 6 && attributeName.indexOf(":") > 0) {
            return attributeName.substring(colonIndex + 1, attributeName.length());
        }
        if (attributeName.equals(ConfigCoreUtils.ATTR_DEFAULT_NAMESPACE)) {
            return uri.substring(uri.lastIndexOf("/") + 1);
        }
        return null;
    }

    @Override
    protected void createButtons(Composite client) {
    }

    @Override
    protected ColumnViewer createViewer(Composite client) {
        return CheckboxTableViewer.newCheckList((Composite)client, (int)2048);
    }

    @Override
    protected SpringConfigContentProvider createViewerContentProvider() {
        return new XsdConfigContentProvider(this.getFormPage());
    }

    @Override
    protected AbstractConfigLabelProvider createViewerLabelProvider() {
        return new NamespacesLabelProvider((IResource)this.getConfigEditor().getResourceFile());
    }

    public void dispose() {
        if (this.xsdViewer != null && this.checkListener != null) {
            this.xsdViewer.removeCheckStateListener((ICheckStateListener)this.checkListener);
        }
        BeansCorePlugin.unregisterNamespaceDefinitionListener((INamespaceDefinitionListener)this);
    }

    private boolean existsInConfiguration(INamespaceDefinition namespaceDefinition) {
        if (this.rootElement != null) {
            NamedNodeMap attributeMap = this.rootElement.getAttributes();
            int i = 0;
            while (i < attributeMap.getLength()) {
                Node currItem = attributeMap.item(i);
                if (currItem.getNodeName().equals(String.valueOf(ConfigCoreUtils.ATTR_NAMESPACE_PREFIX) + namespaceDefinition.getNamespacePrefix((IResource)this.getConfigEditor().getResourceFile()))) {
                    return true;
                }
                if (currItem.getNodeName().equals(ConfigCoreUtils.ATTR_DEFAULT_NAMESPACE) && currItem.getNodeValue().equals(namespaceDefinition.getNamespaceURI())) {
                    return true;
                }
                ++i;
            }
            List schemaLocationAttrs = ConfigCoreUtils.parseSchemaLocationAttr((IDOMDocument)this.getConfigEditor().getDomDocument());
            if (schemaLocationAttrs != null && schemaLocationAttrs.contains(namespaceDefinition.getNamespaceURI())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
    }

    public CountDownLatch getLazyInitializationLatch() {
        return this.lazyInitializationLatch;
    }

    private synchronized List<INamespaceDefinition> getNamespaceDefinitionList() {
        if (!(this.namespaceDefinitionList != null && this.namespaceDefinitionList.size() != 0 || this.loading)) {
            this.loading = true;
            if (this.getConfigEditor().getResourceFile() != null) {
                NamespaceUtils.getNamespaceDefinitions((IProject)this.getConfigEditor().getResourceFile().getProject(), (NamespaceUtils.INamespaceDefinitionTemplate)new NamespaceUtils.INamespaceDefinitionTemplate(){

                    public void doWithNamespaceDefinitions(INamespaceDefinition[] namespaceDefinitions, IProject project) {
                        ArrayList<INamespaceDefinition> newNamespaceDefinitions = new ArrayList<INamespaceDefinition>(Arrays.asList(namespaceDefinitions));
                        NamespacesMasterPart.this.namespaceDefinitionList = NamespacesMasterPart.this.triggerLoadNamespaceDefinitionList(newNamespaceDefinitions);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (NamespacesMasterPart.this.getViewer().getControl() != null && !NamespacesMasterPart.this.getViewer().getControl().isDisposed()) {
                                    NamespacesMasterPart.this.getViewer().setInput((Object)NamespacesMasterPart.this.getConfigEditor().getDomDocument());
                                    NamespacesMasterPart.this.refresh();
                                }
                            }
                        });
                        NamespacesMasterPart.this.loading = false;
                        NamespacesMasterPart.this.lazyInitializationLatch.countDown();
                    }
                });
            }
        }
        return this.namespaceDefinitionList;
    }

    private Object[] getPreselectedElements() {
        Object[] availableNamespaces;
        HashSet<INamespaceDefinition> checkedElements = new HashSet<INamespaceDefinition>();
        Object[] objectArray = availableNamespaces = ((IStructuredContentProvider)this.getViewer().getContentProvider()).getElements((Object)this.getConfigEditor().getDomDocument());
        int n = availableNamespaces.length;
        int n2 = 0;
        while (n2 < n) {
            Object currAvailableNamespace = objectArray[n2];
            INamespaceDefinition currNamespaceDefinition = (INamespaceDefinition)currAvailableNamespace;
            if (this.existsInConfiguration(currNamespaceDefinition)) {
                checkedElements.add(currNamespaceDefinition);
                this.selectedNamespaces.add(currNamespaceDefinition);
                String existingVersion = ConfigCoreUtils.getSelectedSchemaLocation((IDOMDocument)this.getConfigEditor().getDomDocument(), (String)currNamespaceDefinition.getNamespaceURI());
                if (!"".equals(existingVersion)) {
                    this.selectedVersions.put(currNamespaceDefinition, existingVersion);
                }
            }
            ++n2;
        }
        return checkedElements.toArray();
    }

    private String getSchemaLocationValue(INamespaceDefinition namespaceDefinition, Map<INamespaceDefinition, String> schemaVersions) {
        String schemaVersion = schemaVersions.get(namespaceDefinition);
        if (schemaVersion == null) {
            schemaVersion = namespaceDefinition.getDefaultSchemaLocation((IResource)this.getConfigEditor().getResourceFile());
        }
        return String.valueOf(namespaceDefinition.getNamespaceURI()) + " " + schemaVersion;
    }

    protected Map<INamespaceDefinition, String> getSchemaVersions() {
        return this.selectedVersions;
    }

    @Override
    protected String getSectionDescription() {
        return Messages.getString("NamespacesMasterPart.MASTER_SECTION_DESCRIPTION");
    }

    @Override
    protected String getSectionTitle() {
        return Messages.getString("NamespacesMasterPart.MASTER_SECTION_TITLE");
    }

    private boolean isUnknownNamespace(String attributeName, String namespaceUri, List<INamespaceDefinition> namespaceDefinitionList) {
        if (attributeName.toLowerCase().startsWith("xmlns:xsi")) {
            return false;
        }
        if (attributeName.toLowerCase().startsWith(ConfigCoreUtils.ATTR_NAMESPACE_PREFIX) && !this.namespaceAttributeExistsInList(attributeName, namespaceUri, namespaceDefinitionList) && this.attributeNameToPrefix(attributeName, namespaceUri) != null) {
            return true;
        }
        return attributeName.equalsIgnoreCase(ConfigCoreUtils.ATTR_DEFAULT_NAMESPACE) && !this.namespaceAttributeExistsInList(attributeName, namespaceUri, namespaceDefinitionList);
    }

    private boolean namespaceAttributeExistsInList(String attributeName, String namespaceUri, List<INamespaceDefinition> namespaces) {
        String namespacePrefix = this.attributeNameToPrefix(attributeName, namespaceUri);
        Iterator<INamespaceDefinition> iterator = namespaces.iterator();
        while (iterator.hasNext()) {
            INamespaceDefinition namespaceDefinition;
            INamespaceDefinition currNamespaceDefinition = namespaceDefinition = iterator.next();
            if ((namespacePrefix == null || !namespacePrefix.equals(currNamespaceDefinition.getNamespacePrefix((IResource)this.getConfigEditor().getResourceFile()))) && !namespaceUri.equalsIgnoreCase(currNamespaceDefinition.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    public void onNamespaceDefinitionRegistered(INamespaceDefinitionListener.NamespaceDefinitionChangeEvent event) {
        if (this.shouldRefresh(event)) {
            this.namespaceDefinitionList.clear();
            this.getNamespaceDefinitionList();
        }
    }

    public void onNamespaceDefinitionUnregistered(INamespaceDefinitionListener.NamespaceDefinitionChangeEvent event) {
        this.onNamespaceDefinitionRegistered(event);
    }

    private void openPontDialog() {
        IPreferenceStore prefStore = ConfigUiPlugin.getDefault().getPreferenceStore();
        if (prefStore.getString("com.springsource.config.ui.prefs.tabs.dialog").equals("prompt")) {
            MessageDialogWithToggle.openInformation((Shell)this.getFormPage().getSite().getShell(), (String)Messages.getString("NamespacesMasterPart.PONT_DIALOG_TITLE"), (String)Messages.getString("NamespacesMasterPart.PONT_DIALOG_MESSAGE"), (String)Messages.getString("NamespacesMasterPart.PONT_DIALOG_CHECKBOX"), (boolean)false, (IPreferenceStore)prefStore, (String)"com.springsource.config.ui.prefs.tabs.dialog");
        }
    }

    @Override
    protected void postCreateContents() {
        ColumnViewer viewer = this.getViewer();
        if (viewer != null && viewer instanceof CheckboxTableViewer) {
            this.checkListener = new CheckStateListener();
            this.xsdViewer = (CheckboxTableViewer)viewer;
            this.xsdViewer.setCheckedElements(this.getPreselectedElements());
            this.xsdViewer.addCheckStateListener((ICheckStateListener)this.checkListener);
        }
    }

    @Override
    public void refresh() {
        this.xsdViewer.setCheckedElements(this.getPreselectedElements());
        super.refresh();
    }

    protected void removeXsdDefinition(INamespaceDefinition definition) {
        if (this.existsInConfiguration(definition)) {
            StructuredTextViewer textView = this.getConfigEditor().getTextViewer();
            IDOMDocument doc = this.getConfigEditor().getDomDocument();
            doc.getModel().beginRecording((Object)textView);
            this.rootElement.removeAttribute(String.valueOf(ConfigCoreUtils.ATTR_NAMESPACE_PREFIX) + definition.getNamespacePrefix((IResource)this.getConfigEditor().getResourceFile()));
            Attr attr = this.rootElement.getAttributeNode(ConfigCoreUtils.ATTR_DEFAULT_NAMESPACE);
            if (attr != null && attr.getNodeValue().equals(definition.getNamespaceURI())) {
                this.rootElement.removeAttributeNode(attr);
            }
            this.selectedNamespaces.remove(definition);
            this.updateXsdVersion();
            doc.getModel().endRecording((Object)textView);
        }
    }

    private boolean shouldRefresh(INamespaceDefinitionListener.NamespaceDefinitionChangeEvent event) {
        return event.getProject() == null || event.getProject().equals((Object)this.getConfigEditor().getResourceFile().getProject());
    }

    private List<INamespaceDefinition> triggerLoadNamespaceDefinitionList(List<INamespaceDefinition> namespaceDefinitionList) {
        List schemaInfo;
        if (this.rootElement == null) {
            this.rootElement = this.getConfigEditor().getDomDocument().getDocumentElement();
        }
        if (this.rootElement != null) {
            NamedNodeMap beanAttributes = this.rootElement.getAttributes();
            int i = 0;
            while (i < beanAttributes.getLength()) {
                String uri;
                Node currAttributeNode = beanAttributes.item(i);
                String currAttributeName = currAttributeNode.getNodeName();
                if (this.isUnknownNamespace(currAttributeName, uri = currAttributeNode.getNodeValue(), namespaceDefinitionList)) {
                    String schemaVersion = ConfigCoreUtils.getSelectedSchemaLocation((IDOMDocument)this.getConfigEditor().getDomDocument(), (String)uri);
                    DefaultNamespaceDefinition namespaceDefinition = new DefaultNamespaceDefinition(this.attributeNameToPrefix(currAttributeName, uri), uri, schemaVersion, StsUiImages.XML_FILE.createImage());
                    if (!"".equals(schemaVersion)) {
                        this.selectedVersions.put((INamespaceDefinition)namespaceDefinition, schemaVersion);
                    }
                    namespaceDefinitionList.add((INamespaceDefinition)namespaceDefinition);
                }
                ++i;
            }
        }
        if ((schemaInfo = ConfigCoreUtils.parseSchemaLocationAttr((IDOMDocument)this.getConfigEditor().getDomDocument())) != null) {
            Iterator iter = schemaInfo.iterator();
            while (iter.hasNext()) {
                String uri = (String)iter.next();
                if (!iter.hasNext()) continue;
                String schemaVersion = (String)iter.next();
                if (this.namespaceAttributeExistsInList(ConfigCoreUtils.ATTR_SCHEMA_LOCATION, uri, namespaceDefinitionList)) continue;
                DefaultNamespaceDefinition namespaceDefinition = new DefaultNamespaceDefinition(this.attributeNameToPrefix(ConfigCoreUtils.ATTR_SCHEMA_LOCATION, uri), uri, schemaVersion, StsUiImages.XML_FILE.createImage());
                if (!"".equals(schemaVersion)) {
                    this.selectedVersions.put((INamespaceDefinition)namespaceDefinition, schemaVersion);
                }
                namespaceDefinitionList.add((INamespaceDefinition)namespaceDefinition);
            }
        }
        return namespaceDefinitionList;
    }

    public void updateDefinitionFromCheckState(INamespaceDefinition definition, boolean checked) {
        if (checked) {
            this.addXsdDefinition(definition);
        } else {
            this.removeXsdDefinition(definition);
        }
        this.openPontDialog();
    }

    protected void updateXsdVersion() {
        this.rootElement.removeAttribute(ConfigCoreUtils.ATTR_SCHEMA_LOCATION);
        Set<INamespaceDefinition> namespaces = this.selectedNamespaces;
        Map<INamespaceDefinition, String> schemaVersions = this.getSchemaVersions();
        String schemaLocationAttrVal = null;
        for (INamespaceDefinition currNamespaceDefinition : namespaces) {
            if (currNamespaceDefinition.getDefaultSchemaLocation((IResource)this.getConfigEditor().getResourceFile()) == null) continue;
            String currNamespaceDefSchemaLocationVal = this.getSchemaLocationValue(currNamespaceDefinition, schemaVersions);
            schemaLocationAttrVal = schemaLocationAttrVal == null ? currNamespaceDefSchemaLocationVal : String.valueOf(schemaLocationAttrVal) + "\n\t\t" + currNamespaceDefSchemaLocationVal;
        }
        if (schemaLocationAttrVal != null) {
            this.rootElement.setAttribute(ConfigCoreUtils.ATTR_SCHEMA_LOCATION, schemaLocationAttrVal.trim());
        }
        this.formatProcessor.formatNode((Node)this.rootElement);
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getElement() != null && event.getElement() instanceof INamespaceDefinition) {
                INamespaceDefinition definition = (INamespaceDefinition)event.getElement();
                NamespacesMasterPart.this.updateDefinitionFromCheckState(definition, event.getChecked());
            }
        }
    }

    private class XsdConfigContentProvider
    extends SpringConfigContentProvider {
        public XsdConfigContentProvider(AbstractConfigFormPage page) {
            super(page);
        }

        @Override
        protected List<String> getChildNames(IDOMElement element) {
            return new ArrayList<String>();
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List result = new ArrayList();
            if (inputElement instanceof Document) {
                Document document = (Document)inputElement;
                NamespacesMasterPart.this.rootElement = document.getDocumentElement();
                result = NamespacesMasterPart.this.namespaceDefinitionList;
            }
            return result.toArray();
        }
    }
}

