/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.springframework.ide.eclipse.data.jdt.core.FindByMethodCompletionProposal;
import org.springframework.ide.eclipse.data.jdt.core.RepositoryInformation;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class FindByMethodCompletionProposalComputer
extends JavaCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        int tokenLocation;
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return super.computeCompletionProposals(context, monitor);
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        CompletionContext coreContext = javaContext.getCoreContext();
        if (coreContext != null && ((tokenLocation = coreContext.getTokenLocation()) & 1) == 0) {
            return super.computeCompletionProposals(context, monitor);
        }
        if (!SpringCoreUtils.isSpringProject((IResource)javaContext.getProject().getProject())) {
            return super.computeCompletionProposals(context, monitor);
        }
        ITextViewer viewer = context.getViewer();
        IDocument document = viewer.getDocument();
        try {
            int invocationOffset;
            int start = invocationOffset = context.getInvocationOffset();
            int end = invocationOffset;
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            if (start < 0) {
                return super.computeCompletionProposals(context, monitor);
            }
            String prefix = document.get(start, end - start);
            if (!"findby".startsWith(prefix.toLowerCase())) {
                return super.computeCompletionProposals(context, monitor);
            }
            if (!(viewer instanceof ISourceViewer)) {
                return super.computeCompletionProposals(context, monitor);
            }
            IType expectedType = javaContext.getExpectedType();
            if (expectedType == null) {
                expectedType = javaContext.getCompilationUnit().findPrimaryType();
            }
            if (expectedType == null) {
                return super.computeCompletionProposals((ContentAssistInvocationContext)javaContext, monitor);
            }
            if (!FindByMethodCompletionProposalComputer.isSpringDataRepository(expectedType, javaContext.getProject())) {
                return super.computeCompletionProposals((ContentAssistInvocationContext)javaContext, monitor);
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            RepositoryInformation repositoryInfo = new RepositoryInformation(expectedType);
            Class<?> domainClass = repositoryInfo.getManagedDomainClass();
            if (domainClass != null) {
                Method[] methods;
                Method[] methodArray = methods = domainClass.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    String propertyName;
                    String methodName;
                    Method method = methodArray[n2];
                    Class<?> returnType = method.getReturnType();
                    if (!"void".equals(returnType.getName()) && method.getParameterTypes().length <= 0 && (methodName = method.getName()).startsWith("get") && !"Class".equals(propertyName = methodName.substring(3, methodName.length())) && !this.containsMethodName(FindByMethodCompletionProposal.getMethodName(propertyName), expectedType)) {
                        proposals.add((ICompletionProposal)new FindByMethodCompletionProposal(propertyName, returnType, domainClass, start, end, javaContext));
                    }
                    ++n2;
                }
            }
            return proposals;
        }
        catch (BadLocationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.data.core", e.getMessage(), (Throwable)e));
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.data.core", e.getMessage(), (Throwable)e));
        }
        return super.computeCompletionProposals(context, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsMethodName(String methodName, IType expectedType) {
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = expectedType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(methodName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.data.core", e.getMessage(), (Throwable)e));
        }
        return false;
    }

    private static boolean isSpringDataRepository(IType type, IJavaProject project) throws JavaModelException {
        String[] interfaces;
        if (type == null) {
            return false;
        }
        if (FindByMethodCompletionProposalComputer.isSpringDataRepository(type)) {
            return true;
        }
        String[] stringArray = interfaces = type.getSuperInterfaceNames();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String[][] resolvedInterfaceTypes;
            String extendedInterface = stringArray[n2];
            if (extendedInterface.contains("Repository") && (resolvedInterfaceTypes = type.resolveType(extendedInterface)) != null) {
                String[][] stringArray2 = resolvedInterfaceTypes;
                int n3 = resolvedInterfaceTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] match = stringArray2[n4];
                    if (match != null && match.length == 2 && FindByMethodCompletionProposalComputer.isSpringDataRepository(project.findType(String.valueOf(match[0]) + "." + match[1]), project)) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSpringDataRepository(IType type) {
        if (RepositoryInformation.isSpringDataRepository(type)) {
            return true;
        }
        return "org.springframework.data.repository.Repository".equals(type.getFullyQualifiedName());
    }
}

