/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.remoteapi.rest;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.exception.HttpProxySettingsException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiSessionExpiredException;
import com.atlassian.theplugin.commons.remoteapi.ServiceUnavailableException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import com.atlassian.theplugin.commons.util.UrlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpSession {
    @NotNull
    protected final HttpSessionCallback callback;
    @NotNull
    private final ConnectionCfg server;
    private static final int MAX_REDIRECTS = 3;
    private String responseCharSet;
    private final Object clientLock = new Object();
    private static ThreadLocal<URL> url = new ThreadLocal();
    private final Map<String, CacheRecord> cache = new WeakHashMap<String, CacheRecord>();

    @NotNull
    protected ConnectionCfg getServer() {
        return this.server;
    }

    protected String getUsername() {
        return this.server.getUsername();
    }

    protected String getPassword() {
        return this.server.getPassword();
    }

    public static URL getUrl() {
        return url.get();
    }

    public static void setUrl(URL urlString) {
        url.set(urlString);
    }

    public static void setUrl(String urlString) throws MalformedURLException {
        AbstractHttpSession.setUrl(new URL(urlString));
    }

    protected String getBaseUrl() {
        return UrlUtil.removeUrlTrailingSlashes(this.server.getUrl());
    }

    public AbstractHttpSession(@NotNull ConnectionCfg server, @NotNull HttpSessionCallback callback) throws RemoteApiMalformedUrlException {
        this.server = server;
        this.callback = callback;
        String myurl = server.getUrl();
        try {
            UrlUtil.validateUrl(myurl);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiMalformedUrlException("Malformed server URL: " + myurl, e);
        }
    }

    protected Document retrieveGetResponse(String urlString) throws IOException, JDOMException, RemoteApiSessionExpiredException {
        String line;
        SAXBuilder builder = new SAXBuilder();
        ByteArrayInputStream in = new ByteArrayInputStream(this.doConditionalGet(urlString));
        InputStreamReader reader = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(reader);
        StringBuilder allInput = new StringBuilder();
        while ((line = br.readLine()) != null) {
            allInput.append(line);
        }
        in.close();
        br.close();
        reader.close();
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(allInput.toString().getBytes());
            Document doc = builder.build((InputStream)bis);
            this.preprocessResult(doc);
            return doc;
        }
        catch (JDOMException e) {
            throw new JDOMException(String.valueOf(e.getMessage()) + "\n\n" + allInput.toString() + "\n");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doUnconditionalGetForTextNonXmlResource(String urlString) throws IOException {
        UrlUtil.validateUrl(urlString);
        AbstractHttpSession.setUrl(urlString);
        Object object = this.clientLock;
        synchronized (object) {
            GetMethod method;
            HttpClient client;
            try {
                client = this.callback.getHttpClient(this.server);
            }
            catch (HttpProxySettingsException e) {
                throw this.createIOException("Connection error. Please set up HTTP Proxy settings", e);
            }
            try {
                method = new GetMethod(urlString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Invalid url " + urlString);
            }
            try {
                method.getParams().setCookiePolicy("compatibility");
                method.getParams().setSoTimeout(client.getParams().getSoTimeout());
                this.callback.configureHttpMethod(this, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                if (method.getStatusCode() != 200) {
                    throw new IOException("HTTP " + method.getStatusCode() + " (" + HttpStatus.getStatusText((int)method.getStatusCode()) + ")\n" + method.getStatusText());
                }
                String string = method.getResponseBodyAsString();
                return string;
            }
            catch (NullPointerException e) {
                throw this.createIOException("Connection error", e);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] doConditionalGet(String urlString) throws IOException {
        UrlUtil.validateUrl(urlString);
        AbstractHttpSession.setUrl(urlString);
        Object object = this.clientLock;
        synchronized (object) {
            GetMethod method;
            HttpClient client;
            try {
                client = this.callback.getHttpClient(this.server);
            }
            catch (HttpProxySettingsException e) {
                throw this.createIOException("Connection error. Please set up HTTP Proxy settings", e);
            }
            try {
                method = new GetMethod(urlString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Invalid url " + urlString);
            }
            CacheRecord cacheRecord = this.cache.get(urlString);
            this.callback.configureHttpMethod(this, (HttpMethod)method);
            if (cacheRecord != null) {
                method.addRequestHeader("If-Modified-Since", cacheRecord.getLastModified());
                method.addRequestHeader("If-None-Match", cacheRecord.getEtag());
            }
            method.addRequestHeader("Accept", "application/xml;q=0.9,*/*");
            try {
                String eTag;
                method.getParams().setCookiePolicy("compatibility");
                method.getParams().setSoTimeout(client.getParams().getSoTimeout());
                client.executeMethod((HttpMethod)method);
                if (method.getStatusCode() == 304 && cacheRecord != null) {
                    byte[] byArray = cacheRecord.getDocument();
                    return byArray;
                }
                if (method.getStatusCode() != 200) {
                    String errorDescription = "HTTP " + method.getStatusCode() + " (" + HttpStatus.getStatusText((int)method.getStatusCode()) + ")";
                    LoggerImpl.getInstance().info(String.valueOf(errorDescription) + "\n" + method.getStatusText());
                    throw this.createIOException(errorDescription, new Exception(method.getResponseBodyAsString()));
                }
                byte[] result = method.getResponseBody();
                String lastModified = method.getResponseHeader("Last-Modified") == null ? null : method.getResponseHeader("Last-Modified").getValue();
                String string = eTag = method.getResponseHeader("Etag") == null ? null : method.getResponseHeader("Etag").getValue();
                if (lastModified != null && eTag != null) {
                    cacheRecord = new CacheRecord(result, lastModified, eTag);
                    this.cache.put(urlString, cacheRecord);
                }
                byte[] byArray = result;
                return byArray;
            }
            catch (NullPointerException e) {
                throw this.createIOException("Connection error", e);
            }
            catch (AuthenticationException e) {
                throw this.createIOException("Connection error", e);
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    public String getResponseCharSet() {
        return this.responseCharSet;
    }

    private IOException createIOException(String message, Throwable cause) {
        IOException ioException = new IOException(message);
        ioException.initCause(cause);
        return ioException;
    }

    protected Document retrievePostResponse(String urlString, Document request) throws IOException, JDOMException, RemoteApiException {
        return this.retrievePostResponse(urlString, request, null);
    }

    protected Document retrievePostResponse(String urlString, Document request, StringBuilder txtHolder) throws IOException, JDOMException, RemoteApiException {
        return this.retrievePostResponse(urlString, request, true, txtHolder);
    }

    protected Document retrievePostResponse(String urlString, Document request, boolean expectResponse) throws JDOMException, RemoteApiException {
        return this.retrievePostResponse(urlString, request, expectResponse, null);
    }

    protected Document retrievePostResponse(String urlString, Document request, boolean expectResponse, StringBuilder txtHolder) throws JDOMException, RemoteApiException {
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        String requestString = serializer.outputString(request);
        return this.retrievePostResponse(urlString, requestString, expectResponse, txtHolder);
    }

    protected Document retrievePostResponse(String urlString, String request, boolean expectResponse) throws JDOMException, RemoteApiException {
        return this.retrievePostResponse(urlString, request, expectResponse, null);
    }

    protected Document retrievePostResponse(String urlString, String request, boolean expectResponse, StringBuilder txtHolder) throws JDOMException, RemoteApiException {
        return this.retrievePostResponseInternal(urlString, request, expectResponse, 0, txtHolder);
    }

    private Document retrievePostResponseInternal(String urlString, final String request, boolean expectResponse, int redirectCounter, StringBuilder txtHolder) throws JDOMException, RemoteApiException {
        return this.retrievePostResponseInternalImpl(urlString, new PostMethodPreparer(){

            public void prepare(PostMethod postMethod) throws UnsupportedEncodingException {
                if (request != null && !"".equals(request)) {
                    postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(request, "application/xml", "UTF-8"));
                }
            }
        }, expectResponse, redirectCounter, txtHolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document retrievePostResponseInternalImpl(String urlString, PostMethodPreparer postMethodPreparer, boolean expectResponse, int redirectCounter, StringBuilder txtHolder) throws JDOMException, RemoteApiException {
        Document doc = null;
        String baseUrl = urlString;
        int i = 0;
        while (true) {
            block28: {
                if (i > 3) {
                    return doc;
                }
                try {
                    UrlUtil.validateUrl(baseUrl);
                    AbstractHttpSession.setUrl(baseUrl);
                }
                catch (MalformedURLException e) {
                    throw new RemoteApiException(e.getMessage(), e);
                }
                Object object = this.clientLock;
                synchronized (object) {
                    HttpClient client;
                    try {
                        client = this.callback.getHttpClient(this.server);
                    }
                    catch (HttpProxySettingsException e) {
                        throw new RemoteApiException("Connection error. Please set up HTTP Proxy settings", e);
                    }
                    PostMethod method = new PostMethod(baseUrl);
                    try {
                        method.getParams().setCookiePolicy("compatibility");
                        method.getParams().setSoTimeout(client.getParams().getSoTimeout());
                        method.addRequestHeader("Accept", "application/xml");
                        this.callback.configureHttpMethod(this, (HttpMethod)method);
                        postMethodPreparer.prepare(method);
                        client.executeMethod((HttpMethod)method);
                        int httpStatus = method.getStatusCode();
                        if (httpStatus == 204) {
                            Document document = doc;
                            return document;
                        }
                        if (httpStatus == 301 || httpStatus == 302) {
                            Header newLocation = method.getResponseHeader("Location");
                            if (newLocation == null) {
                                throw new RemoteApiException("Connection error. Received redirection without new target address");
                            }
                            String lUrl = newLocation.getValue();
                            if (!lUrl.endsWith("/success")) {
                                if (!lUrl.endsWith("/JiraLockedError")) throw new RemoteApiException("Connection error. Received too many redirects (more than 3)");
                                throw new RemoteApiException("JIRA is locked. Please contact your JIRA administrator.");
                            }
                            String newBaseUrl = lUrl.substring(0, lUrl.lastIndexOf("/success"));
                            if (!baseUrl.startsWith(newBaseUrl)) {
                                baseUrl = String.valueOf(newBaseUrl) + "/";
                                break block28;
                            }
                        } else {
                            String errorDescription;
                            if (httpStatus == 403) {
                                errorDescription = "HTTP 403 (" + HttpStatus.getStatusText((int)403) + ")";
                                LoggerImpl.getInstance().info(String.valueOf(errorDescription) + "\n" + method.getStatusText());
                                throw new RemoteApiException(errorDescription, new Exception(method.getResponseBodyAsString()));
                            }
                            if (httpStatus != 200 && httpStatus != 201 && !method.getResponseBodyAsString().startsWith("<html>")) {
                                SAXBuilder builder = new SAXBuilder();
                                StringWriter writer = new StringWriter();
                                IOUtils.copy((InputStream)method.getResponseBodyAsStream(), (Writer)writer, (String)"UTF-8");
                                String response = writer.toString();
                                if (txtHolder != null) {
                                    txtHolder.append(response);
                                }
                                Document document = builder.build((InputStream)new ByteArrayInputStream(response.getBytes()));
                                throw this.buildExceptionText(method.getStatusCode(), document);
                            }
                            if (httpStatus == 406) {
                                errorDescription = "HTTP " + httpStatus + " (" + "Authentication failed (probably invalid username or password)." + HttpStatus.getStatusText((int)httpStatus) + ")";
                                LoggerImpl.getInstance().info(String.valueOf(errorDescription) + "\n" + method.getStatusText());
                                throw new RemoteApiException(errorDescription, new Exception(method.getResponseBodyAsString()));
                            }
                            if (httpStatus != 200 && httpStatus != 201) {
                                errorDescription = "HTTP " + httpStatus + " (" + HttpStatus.getStatusText((int)httpStatus) + ")";
                                LoggerImpl.getInstance().info(String.valueOf(errorDescription) + "\n" + method.getStatusText());
                                throw new RemoteApiException(errorDescription, new Exception(method.getResponseBodyAsString()));
                            }
                        }
                        this.responseCharSet = method.getResponseCharSet();
                        if (!expectResponse) return doc;
                        SAXBuilder builder = new SAXBuilder();
                        doc = builder.build(method.getResponseBodyAsStream());
                        this.preprocessResult(doc);
                        return doc;
                    }
                    catch (NullPointerException e) {
                        throw new RemoteApiException("Connection error to [" + baseUrl + "]", e);
                    }
                    catch (IOException e) {
                        throw new RemoteApiException(e.getMessage(), e);
                    }
                    finally {
                        this.preprocessMethodResult((HttpMethod)method);
                        method.releaseConnection();
                    }
                }
            }
            ++i;
        }
    }

    protected Document retrievePostResponseWithForm(String urlString, final Map<String, String> form, boolean expectResponse) throws JDOMException, RemoteApiException {
        return this.retrievePostResponseInternalImpl(urlString, new PostMethodPreparer(){

            public void prepare(PostMethod postMethod) throws UnsupportedEncodingException {
                if (form != null) {
                    for (Map.Entry formEntry : form.entrySet()) {
                        postMethod.addParameter((String)formEntry.getKey(), (String)formEntry.getValue());
                    }
                }
            }
        }, expectResponse, 0, null);
    }

    protected Document retrievePostResponse(String urlString, Part[] parts, boolean expectResponse) throws JDOMException, RemoteApiException {
        return this.retrievePostResponseInternal(urlString, parts, expectResponse, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document retrievePostResponseInternal(String urlString, Part[] parts, boolean expectResponse, int redirectCounter) throws JDOMException, RemoteApiException {
        doc = null;
        var6_6 = this.clientLock;
        synchronized (var6_6) {
            try {
                client = this.callback.getHttpClient(this.server);
            }
            catch (HttpProxySettingsException e) {
                throw new RemoteApiException("Connection error to [" + urlString + "]. Please set up HTTP Proxy settings", e);
            }
            method = new PostMethod(urlString);
            try {
                method.getParams().setBooleanParameter("http.protocol.expect-continue", true);
                method.getParams().setCookiePolicy("compatibility");
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
                this.callback.configureHttpMethod(this, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                httpStatus = method.getStatusCode();
                if (httpStatus == 204) {
                    var13_13 = doc;
                    return var13_13;
                }
                if (httpStatus != 301 && httpStatus != 302) ** GOTO lbl31
                if (redirectCounter < 3) {
                    newLocation = method.getResponseHeader("Location");
                    if (newLocation == null) {
                        throw new RemoteApiException("Connection error. Received redirection without new target address");
                    }
                    var13_14 = this.retrievePostResponseInternal(newLocation.getValue(), parts, expectResponse, redirectCounter + 1);
                    return var13_14;
                }
                throw new RemoteApiException("Connection error. Received too many redirects (more than 3)");
lbl31:
                // 1 sources

                if (httpStatus != 200 && httpStatus != 201) {
                    builder = new SAXBuilder();
                    document = builder.build(method.getResponseBodyAsStream());
                    throw this.buildExceptionText(method.getStatusCode(), document);
                }
                if (expectResponse == false) return doc;
                builder = new SAXBuilder();
                doc = builder.build(method.getResponseBodyAsStream());
                this.preprocessResult(doc);
            }
            catch (NullPointerException e) {
                throw new RemoteApiException("Connection error to [" + urlString + "]", e);
            }
            catch (IOException e) {
                throw new RemoteApiException(String.valueOf(IOException.class.getSimpleName()) + " encountered while posting data to [" + urlString + "]: " + e.getMessage(), e);
            }
            finally {
                this.preprocessMethodResult((HttpMethod)method);
                method.releaseConnection();
            }
            return doc;
        }
    }

    private RemoteApiException buildExceptionText(int statusCode, Document document) throws JDOMException {
        List messages;
        StringBuilder textBuilder = new StringBuilder().append("Server returned HTTP ").append(statusCode).append(" (").append(HttpStatus.getStatusText((int)statusCode)).append(")\n").append("Reason: ");
        XPath xpath = XPath.newInstance((String)"error/code");
        List nodes = xpath.selectNodes((Object)document);
        if (nodes != null && !nodes.isEmpty()) {
            textBuilder.append(((Element)nodes.get(0)).getValue()).append(" ");
        }
        if ((messages = (xpath = XPath.newInstance((String)"error/message")).selectNodes((Object)document)) != null && !messages.isEmpty()) {
            textBuilder.append("\nMessage: ").append(((Element)messages.get(0)).getValue());
        }
        if ((messages = (xpath = XPath.newInstance((String)"status/message")).selectNodes((Object)document)) != null && !messages.isEmpty()) {
            textBuilder.append("\nMessage: ").append(((Element)messages.get(0)).getValue());
        }
        String serverStackTrace = null;
        XPath xpath2 = XPath.newInstance((String)"error/stacktrace");
        List nodes2 = xpath2.selectNodes((Object)document);
        if (nodes2 != null && !nodes2.isEmpty()) {
            serverStackTrace = "\nStacktrace from the server:\n";
            serverStackTrace = String.valueOf(serverStackTrace) + ((Element)nodes2.get(0)).getValue();
        }
        return new RemoteApiException(textBuilder.toString(), serverStackTrace);
    }

    protected Document retrieveDeleteResponse(String urlString, boolean expectResponse) throws IOException, JDOMException, RemoteApiSessionExpiredException {
        return this.retrieveDeleteResponseInternal(urlString, expectResponse, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document retrieveDeleteResponseInternal(String urlString, boolean expectResponse, int redirectCounter) throws IOException, JDOMException, RemoteApiSessionExpiredException {
        UrlUtil.validateUrl(urlString);
        doc = null;
        var5_5 = this.clientLock;
        synchronized (var5_5) {
            try {
                client = this.callback.getHttpClient(this.server);
            }
            catch (HttpProxySettingsException e) {
                throw this.createIOException("Connection error. Please set up HTTP Proxy settings", e);
            }
            method = new DeleteMethod(urlString);
            try {
                method.getParams().setCookiePolicy("compatibility");
                method.getParams().setSoTimeout(client.getParams().getSoTimeout());
                this.callback.configureHttpMethod(this, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
                if (statusCode == 204) {
                    return null;
                }
                if (statusCode != 301 && statusCode != 302) ** GOTO lbl30
                if (redirectCounter < 3) {
                    newLocation = method.getResponseHeader("Location");
                    if (newLocation == null) {
                        throw new IOException("Connection error. Received redirection without new target address");
                    }
                    var11_13 = this.retrieveDeleteResponseInternal(newLocation.getValue(), expectResponse, redirectCounter + 1);
                    return var11_13;
                }
                throw new IOException("Connection error. Received too many redirects (more than 3)");
lbl30:
                // 1 sources

                if (method.getStatusCode() != 200) {
                    throw new IOException("HTTP status code " + method.getStatusCode() + ": " + method.getStatusText());
                }
                if (expectResponse == false) return doc;
                builder = new SAXBuilder();
                doc = builder.build(method.getResponseBodyAsStream());
                this.preprocessResult(doc);
            }
            catch (NullPointerException e) {
                throw this.createIOException("Connection error", e);
            }
            finally {
                method.releaseConnection();
            }
            return doc;
        }
    }

    protected abstract void adjustHttpHeader(HttpMethod var1);

    protected abstract void preprocessResult(Document var1) throws JDOMException, RemoteApiSessionExpiredException;

    protected abstract void preprocessMethodResult(HttpMethod var1) throws RemoteApiException, ServiceUnavailableException;

    public static String getServerNameFromUrl(String urlString) {
        int pos = urlString.indexOf("://");
        if (pos != -1) {
            urlString = urlString.substring(pos + 1 + 2);
        }
        if ((pos = urlString.indexOf("/")) != -1) {
            urlString = urlString.substring(0, pos);
        }
        return urlString;
    }

    private final class CacheRecord {
        private final byte[] document;
        private final String lastModified;
        private final String etag;

        private CacheRecord(byte[] document, String lastModified, String etag) {
            if (document == null || lastModified == null || etag == null) {
                throw new IllegalArgumentException("null");
            }
            this.document = document;
            this.lastModified = lastModified;
            this.etag = etag;
        }

        public byte[] getDocument() {
            return this.document;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getEtag() {
            return this.etag;
        }
    }

    protected static interface PostMethodPreparer {
        public void prepare(PostMethod var1) throws UnsupportedEncodingException;
    }
}

