/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.theplugin.commons.crucible.api.model.CrucibleAction;
import com.atlassian.theplugin.commons.crucible.api.model.PermId;
import com.atlassian.theplugin.commons.crucible.api.model.ReviewType;
import com.atlassian.theplugin.commons.crucible.api.model.Reviewer;
import com.atlassian.theplugin.commons.crucible.api.model.State;
import com.atlassian.theplugin.commons.crucible.api.model.User;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicReview {
    private Set<Reviewer> reviewers;
    private Set<CrucibleAction> transitions = MiscUtil.buildHashSet();
    private Set<CrucibleAction> actions = MiscUtil.buildHashSet();
    @NotNull
    private User author;
    private User creator;
    private String description;
    @Nullable
    private User moderator;
    private String name;
    @Nullable
    private PermId parentReview;
    private PermId permId;
    @NotNull
    private String projectKey;
    private String repoName;
    private State state;
    private boolean allowReviewerToJoin;
    private int metricsVersion;
    private Date createDate;
    private Date closeDate;
    @Nullable
    private DateTime dueDate;
    private String summary;
    private final String serverUrl;
    private final ReviewType type;

    public BasicReview(@NotNull ReviewType type, @NotNull String serverUrl, @NotNull String projectKey, @NotNull User author, @Nullable User moderator) {
        this.type = type;
        this.serverUrl = serverUrl;
        this.projectKey = projectKey;
        this.author = author;
        this.moderator = moderator;
    }

    public ReviewType getType() {
        return this.type;
    }

    public void setReviewers(Set<Reviewer> reviewers) {
        this.reviewers = reviewers;
    }

    public void setTransitions(@NotNull Collection<CrucibleAction> transitions) {
        this.transitions = MiscUtil.buildHashSet(transitions);
    }

    public void setActions(@NotNull Set<CrucibleAction> actions) {
        this.actions = MiscUtil.buildHashSet(actions);
    }

    public void setAuthor(@NotNull User author) {
        this.author = author;
    }

    @NotNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    public Set<Reviewer> getReviewers() {
        return this.reviewers;
    }

    public Set<CrucibleAction> getTransitions() {
        return this.transitions;
    }

    @NotNull
    public Set<CrucibleAction> getActions() {
        return this.actions;
    }

    public boolean isCompleted() {
        for (Reviewer reviewer : this.reviewers) {
            if (reviewer.isCompleted()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public User getAuthor() {
        return this.author;
    }

    public User getCreator() {
        return this.creator;
    }

    public void setCreator(User value) {
        this.creator = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public User getModerator() {
        return this.moderator;
    }

    public void setModerator(User value) {
        this.moderator = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Nullable
    public PermId getParentReview() {
        return this.parentReview;
    }

    public void setParentReview(PermId value) {
        this.parentReview = value;
    }

    @Nullable
    public PermId getPermId() {
        return this.permId;
    }

    public void setPermId(PermId value) {
        this.permId = value;
    }

    @NotNull
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(@NotNull String value) {
        this.projectKey = value;
    }

    @Nullable
    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String value) {
        this.repoName = value;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public void setState(State value) {
        this.state = value;
    }

    public boolean isAllowReviewerToJoin() {
        return this.allowReviewerToJoin;
    }

    public void setAllowReviewerToJoin(boolean allowReviewerToJoin) {
        this.allowReviewerToJoin = allowReviewerToJoin;
    }

    public int getMetricsVersion() {
        return this.metricsVersion;
    }

    public void setMetricsVersion(int metricsVersion) {
        this.metricsVersion = metricsVersion;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicReview that = (BasicReview)o;
        return !(this.permId != null ? !this.permId.equals(that.permId) : that.permId != null);
    }

    public int hashCode() {
        int result = this.permId != null ? this.permId.hashCode() : 0;
        return result;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDueDate(DateTime dueDate) {
        this.dueDate = dueDate;
    }

    public DateTime getDueDate() {
        return this.dueDate;
    }
}

