/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.cfg.ServerCfg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedServerList
extends ArrayList<ServerCfg> {
    public static SharedServerList merge(SharedServerList currentConfig, SharedServerList loadedFromFile, Collection<ServerCfg> allServers) {
        LinkedList<ServerCfg> sharedList = new LinkedList<ServerCfg>();
        HashSet<String> storedIds = new HashSet<String>();
        HashSet<String> deletedIds = new HashSet<String>();
        SharedServerList newList = new SharedServerList();
        HashSet<String> nonShared = new HashSet<String>();
        for (ServerCfg s : allServers) {
            if (s.isShared()) continue;
            nonShared.add(s.getServerId().getId());
        }
        sharedList.addAll(currentConfig);
        sharedList.addAll(loadedFromFile);
        for (ServerCfg server : sharedList) {
            String uuid = server.getServerId().toString();
            if (server.getUrl() == null || server.getUrl().length() <= 0 || storedIds.contains(uuid) || deletedIds.contains(uuid)) continue;
            if (server.isDeleted()) {
                deletedIds.add(uuid);
                continue;
            }
            if (nonShared.contains(server.getServerId().getId())) continue;
            newList.add(server);
            storedIds.add(uuid);
        }
        return newList;
    }
}

