/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.contentassist.webflow;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeanReferenceSearchRequestor;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;

public class WebflowBeanReferenceContentAssistCalculator
implements IContentAssistCalculator {
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        IWebflowConfig config;
        String matchString = context.getMatchString();
        if (matchString == null) {
            matchString = "";
        }
        IFile file = context.getFile();
        BeanReferenceSearchRequestor requestor = new BeanReferenceSearchRequestor(recorder);
        if (file != null && file.exists() && (config = Activator.getModel().getProject(file.getProject()).getConfig(file)) != null) {
            Set beans = WebflowModelUtils.getBeans((IWebflowConfig)config);
            for (IBean bean : beans) {
                requestor.acceptSearchMatch(bean, file, matchString);
            }
        }
    }
}

