/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ConfigurationWriter;
import net.sf.eclipsecs.core.config.GlobalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.projectconfig.LocalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectConfigurationEditor
implements ICheckConfigurationEditor {
    private CheckConfigurationWorkingCopy mWorkingCopy;
    private CheckConfigurationPropertiesDialog mCheckConfigDialog;
    private Text mConfigName;
    private Text mLocation;
    private Button mBtnBrowse;
    private Text mDescription;
    private Button mChkProtectConfig;

    @Override
    public void initialize(CheckConfigurationWorkingCopy checkConfiguration, CheckConfigurationPropertiesDialog dialog) {
        this.mWorkingCopy = checkConfiguration;
        this.mCheckConfigDialog = dialog;
    }

    @Override
    public Control createEditorControl(Composite parent, final Shell shell) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        Label lblConfigName = new Label(contents, 0);
        lblConfigName.setText(Messages.CheckConfigurationPropertiesDialog_lblName);
        GridData gd = new GridData();
        lblConfigName.setLayoutData((Object)gd);
        this.mConfigName = new Text(contents, 18436);
        gd = new GridData(768);
        this.mConfigName.setLayoutData((Object)gd);
        Label lblConfigLocation = new Label(contents, 0);
        lblConfigLocation.setText(Messages.CheckConfigurationPropertiesDialog_lblLocation);
        gd = new GridData();
        lblConfigLocation.setLayoutData((Object)gd);
        Composite locationComposite = new Composite(contents, 0);
        locationComposite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        locationComposite.setLayout((Layout)layout);
        this.mLocation = new Text(locationComposite, 18436);
        gd = new GridData(768);
        this.mLocation.setLayoutData((Object)gd);
        this.mBtnBrowse = new Button(locationComposite, 8);
        this.mBtnBrowse.setText(Messages.ProjectConfigurationLocationEditor_btnBrowse);
        this.mBtnBrowse.setLayoutData((Object)new GridData());
        this.mBtnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.ProjectConfigurationLocationEditor_titleSelectConfigFile);
                dialog.setMessage(Messages.ProjectConfigurationLocationEditor_msgSelectConfigFile);
                dialog.setBlockOnOpen(true);
                dialog.setAllowMultiple(false);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 1 && selection[0] instanceof IFile) {
                            return new Status(0, "org.eclipse.ui", 4, new String(), null);
                        }
                        return new Status(4, "org.eclipse.ui", 4, new String(), null);
                    }
                });
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    IFile checkFile = (IFile)result[0];
                    ProjectConfigurationEditor.this.mLocation.setText(checkFile.getFullPath().toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationPropertiesDialog_lblDescription);
        gd = new GridData();
        gd.horizontalSpan = 2;
        lblDescription.setLayoutData((Object)gd);
        this.mDescription = new Text(contents, 19010);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 100;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.mDescription.setLayoutData((Object)gd);
        Group advancedGroup = new Group(contents, 0);
        advancedGroup.setText(Messages.RemoteConfigurationEditor_titleAdvancedOptions);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        advancedGroup.setLayoutData((Object)gd);
        advancedGroup.setLayout((Layout)new GridLayout(2, false));
        this.mChkProtectConfig = new Button((Composite)advancedGroup, 32);
        this.mChkProtectConfig.setText(Messages.ProjectConfigurationEditor_chkProtectConfigFile);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mChkProtectConfig.setLayoutData((Object)gd);
        if (this.mWorkingCopy.getName() != null) {
            this.mConfigName.setText(this.mWorkingCopy.getName());
        }
        if (this.mWorkingCopy.getLocation() != null) {
            this.mLocation.setText(this.mWorkingCopy.getLocation());
        }
        if (this.mWorkingCopy.getDescription() != null) {
            this.mDescription.setText(this.mWorkingCopy.getDescription());
        }
        this.mChkProtectConfig.setSelection(Boolean.valueOf((String)this.mWorkingCopy.getAdditionalData().get("protect-config-file")).booleanValue());
        return contents;
    }

    @Override
    public CheckConfigurationWorkingCopy getEditedWorkingCopy() throws CheckstylePluginException {
        this.mWorkingCopy.setName(this.mConfigName.getText());
        this.mWorkingCopy.setDescription(this.mDescription.getText());
        this.mWorkingCopy.getAdditionalData().put("protect-config-file", "" + this.mChkProtectConfig.getSelection());
        try {
            this.mWorkingCopy.setLocation(this.mLocation.getText());
        }
        catch (CheckstylePluginException e) {
            String location = this.mLocation.getText();
            if (StringUtils.trimToNull((String)location) == null) {
                throw e;
            }
            ICheckConfigurationWorkingSet ws = this.mCheckConfigDialog.getCheckConfigurationWorkingSet();
            Path tmp = new Path(location);
            boolean isFirstPartProject = ResourcesPlugin.getWorkspace().getRoot().getProject(tmp.segment(0)).exists();
            if (ws instanceof LocalCheckConfigurationWorkingSet && !isFirstPartProject) {
                location = ((LocalCheckConfigurationWorkingSet)ws).getProject().getFullPath().append(location).toString();
                this.mLocation.setText(location);
            } else if (ws instanceof GlobalCheckConfigurationWorkingSet && !isFirstPartProject) {
                throw new CheckstylePluginException(NLS.bind((String)Messages.ProjectConfigurationEditor_msgNoProjectInWorkspace, (Object)tmp.segment(0)));
            }
            if (this.ensureFileExists(location)) {
                this.mWorkingCopy.setLocation(this.mLocation.getText());
            }
            throw e;
        }
        return this.mWorkingCopy;
    }

    private boolean ensureFileExists(String location) throws CheckstylePluginException {
        IFile file = null;
        try {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location));
        }
        catch (IllegalArgumentException e) {
            CheckstylePluginException.rethrow((Throwable)e);
        }
        if (!file.exists() && file.getLocation() != null) {
            boolean confirm = MessageDialog.openQuestion((Shell)this.mBtnBrowse.getShell(), (String)Messages.ExternalFileConfigurationEditor_titleFileDoesNotExist, (String)Messages.ExternalFileConfigurationEditor_msgFileDoesNotExist);
            if (confirm) {
                block12: {
                    BufferedOutputStream out = null;
                    try {
                        File trueFile = file.getLocation().toFile();
                        if (trueFile.getParentFile() != null) {
                            trueFile.getParentFile().mkdirs();
                        }
                        out = new BufferedOutputStream(new FileOutputStream(trueFile));
                        ConfigurationWriter.writeNewConfiguration((OutputStream)out, (ICheckConfiguration)this.mWorkingCopy);
                        file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (IOException ioe) {
                        CheckstylePluginException.rethrow((Throwable)ioe);
                        IOUtils.closeQuietly(out);
                        break block12;
                    }
                    catch (CoreException e) {
                        try {
                            CheckstylePluginException.rethrow((Throwable)e);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            IOUtils.closeQuietly(out);
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

