/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.springframework.ide.eclipse.config.graph.ConfigGraphPlugin;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.DelegatingLayoutManager;
import org.springframework.ide.eclipse.config.graph.parts.GraphAnimation;
import org.springframework.ide.eclipse.config.graph.parts.GraphLayoutManager;
import org.springframework.ide.eclipse.config.graph.parts.StructuredActivityPart;

public abstract class ActivityDiagramPart
extends StructuredActivityPart
implements IPropertyChangeListener {
    private final AbstractConfigGraphDiagram diagram;
    private DelegatingLayoutManager delegatingLayoutManager;
    private final int direction;
    private boolean isFirstManualLayout;
    private boolean isLayoutReset;
    private final IPreferenceStore prefStore;
    CommandStackListener stackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            if (ActivityDiagramPart.this.delegatingLayoutManager.getActiveLayoutManager() instanceof GraphLayoutManager) {
                if (GraphAnimation.captureLayout(ActivityDiagramPart.this.getFigure())) {
                    while (GraphAnimation.step()) {
                        ActivityDiagramPart.this.getFigure().getUpdateManager().performUpdate();
                    }
                }
                GraphAnimation.end();
            } else {
                ActivityDiagramPart.this.getFigure().getUpdateManager().performUpdate();
            }
        }
    };

    public ActivityDiagramPart(AbstractConfigGraphDiagram diagram, int direction) {
        super(diagram);
        this.diagram = diagram;
        this.prefStore = ConfigGraphPlugin.getDefault().getPreferenceStore();
        this.direction = direction == 16 ? direction : 4;
        this.isFirstManualLayout = true;
    }

    @Override
    public void activate() {
        super.activate();
        this.getViewer().getEditDomain().getCommandStack().addCommandStackListener(this.stackListener);
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    protected void applyOwnResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("LayoutEditPolicy", null);
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer(){

            public void setBounds(Rectangle rect) {
                boolean translate;
                int x = this.bounds.x;
                int y = this.bounds.y;
                boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
                boolean bl = translate = rect.x != x || rect.y != y;
                if (this.isVisible() && (resize || translate)) {
                    this.erase();
                }
                if (translate) {
                    int dx = rect.x - x;
                    int dy = rect.y - y;
                    this.primTranslate(dx, dy);
                }
                this.bounds.width = rect.width;
                this.bounds.height = rect.height;
                if (resize || translate) {
                    this.fireFigureMoved();
                    this.fireCoordinateSystemChanged();
                    this.repaint();
                }
            }
        };
        this.delegatingLayoutManager = new DelegatingLayoutManager(this);
        f.setLayoutManager((LayoutManager)this.delegatingLayoutManager);
        f.setOpaque(true);
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        cLayer.setAntialias(1);
        FanRouter fanRouter = new FanRouter();
        fanRouter.setSeparation(20);
        ShortestPathConnectionRouter router = new ShortestPathConnectionRouter((IFigure)f);
        fanRouter.setNextRouter((ConnectionRouter)router);
        cLayer.setConnectionRouter((ConnectionRouter)fanRouter);
        return f;
    }

    @Override
    public void deactivate() {
        this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.getViewer().getEditDomain().getCommandStack().removeCommandStackListener(this.stackListener);
        super.deactivate();
    }

    public int getDirection() {
        return this.direction;
    }

    private void handleLayoutChange(PropertyChangeEvent event) {
        this.getFigure().setLayoutManager((LayoutManager)this.delegatingLayoutManager);
    }

    private void handleLayoutReset(PropertyChangeEvent event) {
        this.isLayoutReset = true;
        this.isFirstManualLayout = true;
        this.diagram.doResetCoordinates();
        this.handleLayoutChange(event);
    }

    public boolean isFirstManualLayout() {
        return this.isFirstManualLayout;
    }

    @Override
    public boolean isManualLayout() {
        return this.prefStore.getBoolean("com.springsource.config.flow.prefs.manualLayout");
    }

    public boolean isSelectable() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value;
        String property = event.getProperty();
        if ("com.springsource.config.flow.prefs.manualLayout".equals(property)) {
            this.handleLayoutChange(event);
        } else if ("com.springsource.config.flow.properties.resetLayout".equals(property) && (value = event.getNewValue()) != null && value.equals(this.diagram.getNamespaceUri())) {
            this.handleLayoutReset(event);
        }
    }

    public void refresh() {
        ((AbstractConfigGraphDiagram)this.getModelElement()).refreshModelFromXml();
        super.refresh();
    }

    @Override
    protected void refreshVisuals() {
    }

    public boolean setBoundsOnFigure(boolean updateConstraint) {
        List parts = this.getChildren();
        for (ActivityPart part : parts) {
            Rectangle savedBounds;
            Activity activity = part.getModelElement();
            Rectangle bounds = activity.getBounds();
            if (this.isFirstManualLayout && (savedBounds = this.diagram.doReadCoordinates(activity)) != null) {
                bounds = savedBounds;
            }
            IFigure figure = part.getFigure();
            if (bounds == null || figure == null || !updateConstraint) continue;
            this.delegatingLayoutManager.setXYLayoutConstraint(figure, new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height));
            activity.setBounds(bounds);
            activity.setHasManualBounds(true);
        }
        this.isFirstManualLayout = false;
        return true;
    }

    public boolean setBoundsOnModel() {
        List parts = this.getChildren();
        for (ActivityPart part : parts) {
            Activity activity = part.getModelElement();
            IFigure figure = part.getFigure();
            if (figure == null || activity.hasManualBounds() && !this.isLayoutReset) continue;
            Rectangle bounds = figure.getBounds().getCopy();
            activity.setBounds(bounds);
        }
        this.isLayoutReset = false;
        return true;
    }
}

