/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.graph.parts.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public abstract class AbstractConfigEditPartFactory
implements EditPartFactory {
    private final AbstractConfigGraphicalEditor editor;

    public AbstractConfigEditPartFactory(AbstractConfigGraphicalEditor editor) {
        this.editor = editor;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        EditPart part = this.createEditPartFromModel(context, model);
        if (part != null) {
            return part;
        }
        for (IConfigurationElement config : this.editor.getAdapterDefinitions()) {
            try {
                EditPartFactory factory;
                Object obj = config.createExecutableExtension(PageAdaptersExtensionPointConstants.ATTR_EDITPART_FACTORY);
                if (!(obj instanceof EditPartFactory) || (part = (factory = (EditPartFactory)obj).createEditPart(context, model)) == null) continue;
                return part;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.AbstractConfigEditPartFactory_ERROR_CREATING_GRAPH, (Throwable)e));
            }
        }
        return null;
    }

    protected abstract EditPart createEditPartFromModel(EditPart var1, Object var2);
}

