/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import java.util.List;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;

public class ReconnectSourceCommand
extends AbstractTextCommand {
    protected Activity source;
    protected Activity target;
    protected Transition transition;
    protected Activity oldSource;

    public ReconnectSourceCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    public boolean canExecute() {
        if (this.transition.target.equals(this.source)) {
            return false;
        }
        List<Transition> transitions = this.source.getOutgoingTransitions();
        int i = 0;
        while (i < transitions.size()) {
            Transition trans = transitions.get(i);
            if (trans.target.equals(this.target) && !trans.source.equals(this.oldSource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void execute() {
        if (this.source != null) {
            this.oldSource.removeOutgoing(this.transition);
            this.transition.source = this.source;
            this.source.addOutgoing(this.transition);
        }
    }

    public Activity getSource() {
        return this.source;
    }

    public Activity getTarget() {
        return this.target;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setSource(Activity activity) {
        this.source = activity;
    }

    public void setTarget(Activity activity) {
        this.target = activity;
    }

    public void setTransition(Transition trans) {
        this.transition = trans;
        this.target = trans.target;
        this.oldSource = trans.source;
    }
}

