/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.config.graph.parts.DummyLayout;

public class SubgraphFigure
extends Figure {
    protected int direction;
    protected IFigure contents;
    protected IFigure footer;
    protected IFigure header;

    public SubgraphFigure(IFigure header, IFigure footer, int direction) {
        this.direction = direction;
        this.contents = new Figure();
        this.contents.setLayoutManager((LayoutManager)new DummyLayout());
        this.header = header;
        this.add(this.header);
        this.add(this.contents);
        this.footer = footer;
        this.add(this.footer);
    }

    public IFigure getContents() {
        return this.contents;
    }

    public IFigure getFooter() {
        return this.footer;
    }

    public IFigure getHeader() {
        return this.header;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension dim = new Dimension();
        int wHeader = this.getHeader().getPreferredSize().width;
        int wFooter = this.getFooter().getPreferredSize().width;
        dim.width = wHeader >= wFooter ? wHeader : wFooter;
        dim.width += this.getInsets().getWidth();
        dim.height = 50;
        return dim;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        rect = Rectangle.SINGLETON;
        this.getClientArea(rect);
        this.contents.setBounds(rect);
        Dimension size = this.footer.getPreferredSize();
        this.footer.setLocation(rect.getBottomLeft().translate(0, -size.height));
        this.footer.setSize(size);
        size = this.header.getPreferredSize();
        this.header.setLocation(rect.getLocation());
        this.header.setSize(size);
    }

    public void setSelected(boolean value) {
    }
}

