/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class RoundedLineBorder
extends LineBorder {
    public Insets getInsets(IFigure figure) {
        return new Insets(5, 5, 5, 5);
    }

    private void paintEtchedBorder(Graphics g, Rectangle r) {
        Color rgb = ColorConstants.gray;
        Color shadow = FigureUtilities.darker((Color)rgb);
        Color highlight = FigureUtilities.lighter((Color)rgb);
        this.paintEtchedBorder(g, r, shadow, highlight);
        shadow.dispose();
        highlight.dispose();
    }

    private void paintEtchedBorder(Graphics g, Rectangle r, Color shadow, Color highlight) {
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        int arc = 10;
        g.setLineStyle(1);
        g.setLineWidth(1);
        g.setXORMode(false);
        g.setForegroundColor(shadow);
        g.drawRoundRectangle(new Rectangle(x, y, w -= 2, h -= 2), arc, arc);
        g.setForegroundColor(highlight);
        g.drawRoundRectangle(new Rectangle(++x, ++y, w, h), arc, arc);
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        tempRect.setBounds(RoundedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RoundedLineBorder.tempRect.width;
            --RoundedLineBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        if (this.getColor() != null) {
            g.setForegroundColor(this.getColor());
        }
        this.paintEtchedBorder(g, tempRect);
    }
}

