/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.springframework.ide.eclipse.config.graph.figures.ConnectorBorder;

public class BidirectionalConnectorBorder
extends ConnectorBorder {
    private final boolean leftSide;

    public BidirectionalConnectorBorder(int direction, int inputs, int outputs, boolean leftSide) {
        super(direction, inputs, outputs);
        this.leftSide = leftSide;
    }

    @Override
    protected void drawAnchors(Graphics graphics, Rectangle rect) {
        Color foreground = graphics.getForegroundColor();
        Color background = graphics.getBackgroundColor();
        graphics.setBackgroundColor(ColorConstants.gray);
        int capacity = this.inputCapacity + this.outputCapacity;
        if (this.direction == 16) {
            PointList pointlist;
            int end;
            int x1 = rect.x;
            int height = rect.height;
            if (this.leftSide) {
                end = x1;
                pointlist = this.connector;
            } else {
                end = x1 + rect.width;
                pointlist = this.bottomConnector;
            }
            int i = 0;
            while (i < capacity) {
                int y1 = rect.y + (2 * i + 1) * height / (capacity * 2);
                graphics.setForegroundColor(ColorConstants.gray);
                pointlist.translate(end, y1);
                graphics.fillPolygon(pointlist);
                graphics.drawPolygon(pointlist);
                pointlist.translate(-end, -y1);
                ++i;
            }
        } else {
            PointList pointlist;
            int bottom;
            int y1 = rect.y;
            int width = rect.width;
            if (this.leftSide) {
                bottom = y1;
                pointlist = this.connector;
            } else {
                bottom = y1 + rect.height;
                pointlist = this.bottomConnector;
            }
            int i = 0;
            while (i < capacity) {
                int x1 = rect.x + (2 * i + 1) * width / (capacity * 2);
                graphics.setForegroundColor(ColorConstants.gray);
                pointlist.translate(x1, bottom);
                graphics.fillPolygon(pointlist);
                graphics.drawPolygon(pointlist);
                pointlist.translate(-x1, -bottom);
                ++i;
            }
        }
        graphics.setForegroundColor(foreground);
        graphics.setBackgroundColor(background);
    }
}

