/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.namespaces;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.namespaces.IModelElementProvider;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.xml.sax.EntityResolver;

public class NamespaceUtils {
    public static final String NAMESPACES_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.core.namespaces";
    public static final String RESOLVERS_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.core.resolvers";
    public static final String DEFAULT_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    private static Set<NamespaceHandlerResolver> namespaceHandlerResolvers;
    private static Map<String, IModelElementProvider> modelElementProviders;
    private static Set<EntityResolver> entityResolvers;
    private static Map<NamespaceHandlerDescriptor, NamespaceHandler> namespaceHandlers;

    public static String getNameSpaceURI(BeanMetadataElement element) {
        String namespaceURI;
        IModelSourceLocation location = ModelUtils.getSourceLocation((BeanMetadataElement)element);
        if (location instanceof XmlSourceLocation && (namespaceURI = ((XmlSourceLocation)location).getNamespaceURI()) != null) {
            return namespaceURI;
        }
        return DEFAULT_NAMESPACE_URI;
    }

    public static synchronized Map<NamespaceHandlerDescriptor, NamespaceHandler> getNamespaceHandlers() {
        if (namespaceHandlers == null) {
            HashMap<NamespaceHandlerDescriptor, NamespaceHandler> handlers = new HashMap<NamespaceHandlerDescriptor, NamespaceHandler>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACES_EXTENSION_POINT);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement config = iConfigurationElementArray[n4];
                        String uri = config.getAttribute("uri");
                        if (uri != null && config.getAttribute("namespaceHandler") != null) {
                            try {
                                Object handler;
                                String handlerClassName = config.getAttribute("namespaceHandler");
                                String provider = config.getAttribute("provider");
                                if (!StringUtils.hasLength((String)provider)) {
                                    provider = extension.getContributor().getName();
                                }
                                if ((handler = NamespaceUtils.loadHandler(provider, handlerClassName)) instanceof NamespaceHandler) {
                                    NamespaceHandler namespaceHandler = (NamespaceHandler)handler;
                                    namespaceHandler.init();
                                    handlers.put(NamespaceHandlerDescriptor.createNamespaceHandlerDescriptor(uri, null), namespaceHandler);
                                }
                            }
                            catch (InvalidRegistryObjectException e) {
                                BeansCorePlugin.log(e);
                            }
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("namespaceHandler");
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement namespaceHandlerConfig = iConfigurationElementArray2[n6];
                            if (uri != null && namespaceHandlerConfig.getAttribute("class") != null) {
                                try {
                                    Object handler;
                                    String schemaLocation = namespaceHandlerConfig.getAttribute("schemaLocation");
                                    String handlerClassName = namespaceHandlerConfig.getAttribute("class");
                                    String provider = namespaceHandlerConfig.getAttribute("provider");
                                    if (!StringUtils.hasLength((String)provider)) {
                                        provider = extension.getContributor().getName();
                                    }
                                    if ((handler = NamespaceUtils.loadHandler(provider, handlerClassName)) instanceof NamespaceHandler) {
                                        NamespaceHandler namespaceHandler = (NamespaceHandler)handler;
                                        namespaceHandler.init();
                                        handlers.put(NamespaceHandlerDescriptor.createNamespaceHandlerDescriptor(uri, schemaLocation), namespaceHandler);
                                    }
                                }
                                catch (InvalidRegistryObjectException e) {
                                    BeansCorePlugin.log(e);
                                }
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            namespaceHandlers = handlers;
        }
        return namespaceHandlers;
    }

    public static synchronized Map<String, IModelElementProvider> getElementProviders() {
        if (modelElementProviders == null) {
            HashMap<String, IModelElementProvider> providers = new HashMap<String, IModelElementProvider>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACES_EXTENSION_POINT);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement config = iConfigurationElementArray[n4];
                        String uri = config.getAttribute("uri");
                        if (uri != null && config.getAttribute("elementProvider") != null) {
                            try {
                                Object provider = config.createExecutableExtension("elementProvider");
                                if (provider instanceof IModelElementProvider) {
                                    providers.put(uri, (IModelElementProvider)provider);
                                }
                            }
                            catch (CoreException e) {
                                BeansCorePlugin.log(e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            modelElementProviders = providers;
        }
        return modelElementProviders;
    }

    public static synchronized Set<NamespaceHandlerResolver> getNamespaceHandlerResolvers() {
        if (namespaceHandlerResolvers == null) {
            HashSet<NamespaceHandlerResolver> handlers = new HashSet<NamespaceHandlerResolver>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(RESOLVERS_EXTENSION_POINT);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement config = iConfigurationElementArray[n4];
                        if ("namespaceHandlerResolver".equals(config.getName()) && config.getAttribute("class") != null) {
                            try {
                                String handlerClassName = config.getAttribute("class");
                                Object handler = NamespaceUtils.loadHandler(extension.getContributor().getName(), handlerClassName);
                                if (handler instanceof NamespaceHandlerResolver) {
                                    NamespaceHandlerResolver namespaceHandlerResolver = (NamespaceHandlerResolver)handler;
                                    handlers.add(namespaceHandlerResolver);
                                }
                            }
                            catch (InvalidRegistryObjectException e) {
                                BeansCorePlugin.log(e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            handlers.add(BeansCorePlugin.getNamespaceHandlerResolver());
            namespaceHandlerResolvers = handlers;
        }
        return namespaceHandlerResolvers;
    }

    public static synchronized Set<EntityResolver> getEntityResolvers() {
        if (entityResolvers == null) {
            HashSet<EntityResolver> handlers = new HashSet<EntityResolver>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(RESOLVERS_EXTENSION_POINT);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement config = iConfigurationElementArray[n4];
                        if ("entityResolver".equals(config.getName()) && config.getAttribute("class") != null) {
                            try {
                                Object handler = config.createExecutableExtension("class");
                                if (handler instanceof EntityResolver) {
                                    EntityResolver entityResolver = (EntityResolver)handler;
                                    handlers.add(entityResolver);
                                }
                            }
                            catch (CoreException e) {
                                BeansCorePlugin.log(e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            entityResolvers = handlers;
        }
        return entityResolvers;
    }

    public static boolean useNamespacesFromClasspath(IProject project) {
        if (project == null) {
            return false;
        }
        if (SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getBoolean("enable.project.preferences", false)) {
            return SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getBoolean("loadNamespaceHandlerFromClasspath", false);
        }
        return BeansCorePlugin.getDefault().getPluginPreferences().getBoolean("loadNamespaceHandlerFromClasspath");
    }

    public static boolean disableCachingForNamespaceLoadingFromClasspath(IProject project) {
        if (project == null) {
            return false;
        }
        if (SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getBoolean("enable.project.preferences", false)) {
            return SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getBoolean("disableCachingForNamespaceLoadingFromClasspath", false);
        }
        return BeansCorePlugin.getDefault().getPluginPreferences().getBoolean("disableCachingForNamespaceLoadingFromClasspath");
    }

    private static Object loadHandler(String providerBundle, String handlerClassName) {
        Bundle bundle = Platform.getBundle((String)providerBundle);
        if (bundle != null) {
            try {
                Class handlerClass = bundle.loadClass(handlerClassName);
                return BeanUtils.instantiate((Class)handlerClass);
            }
            catch (ClassNotFoundException e) {
                BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", 1, String.format("Problem loading handler with class '%s' from bundle '%s'", handlerClassName, providerBundle), (Throwable)e));
            }
        } else {
            BeansCorePlugin.log((IStatus)new Status(2, "org.springframework.ide.eclipse.beans.core", String.format("Problem loading handler with class '%s' from bundle '%s'", handlerClassName, providerBundle)));
        }
        return null;
    }

    public static class NamespaceHandlerDescriptor {
        private final String namespaceUri;
        private final String schemaLocation;

        NamespaceHandlerDescriptor(String namespaceUri, String schemaLocation) {
            this.namespaceUri = namespaceUri;
            this.schemaLocation = schemaLocation;
        }

        public static NamespaceHandlerDescriptor createNamespaceHandlerDescriptor(String namespaceUri, String schemaLocation) {
            if (StringUtils.hasText((String)schemaLocation)) {
                return new NamespaceHandlerDescriptor(namespaceUri, schemaLocation);
            }
            return new NamespaceHandlerDescriptor(namespaceUri, "*");
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NamespaceHandlerDescriptor)) {
                return false;
            }
            NamespaceHandlerDescriptor other = (NamespaceHandlerDescriptor)obj;
            return this.namespaceUri.equals(other.namespaceUri) && this.schemaLocation.equals(other.schemaLocation);
        }

        public int hashCode() {
            return 0x1F ^ ObjectUtils.nullSafeHashCode((Object)this.namespaceUri) * ObjectUtils.nullSafeHashCode((Object)this.schemaLocation);
        }
    }
}

