/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractNonInfrastructureBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.scripting.ScriptFactory;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class BeanPropertyRule
extends AbstractNonInfrastructureBeanValidationRule
implements IValidationRule<IBeanProperty, IBeansValidationContext> {
    @Override
    protected boolean supportsModelElementForNonInfrastructureBean(IModelElement element, IBeansValidationContext context) {
        return element instanceof IBeanProperty && !SpringCoreUtils.hasPlaceHolder((String)((IBeanProperty)element).getElementName());
    }

    public void validate(IBeanProperty property, IBeansValidationContext context, IProgressMonitor monitor) {
        String mergedClassName;
        TypeHierarchyEngine typeEngine = this.getTypeHierarchyEngine(context);
        IBean bean = (IBean)property.getElementParent();
        BeanDefinition mergedBd = BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        IType type = ValidationRuleUtils.extractBeanClass(mergedBd, bean, mergedClassName = mergedBd.getBeanClassName(), context);
        if (type != null && JdtUtils.isTypeGroovyElement((IType)type)) {
            return;
        }
        if (type != null && !mergedBd.isAbstract() && !JdtUtils.doesImplement((IResource)context.getRootElementResource(), (IType)type, (String)ScriptFactory.class.getName(), (TypeHierarchyEngine)typeEngine)) {
            this.validateProperty(property, type, context, typeEngine);
        }
    }

    private void validateProperty(IBeanProperty property, IType type, IBeansValidationContext context, TypeHierarchyEngine typeHierarchyEngine) {
        String propertyName = property.getElementName();
        try {
            int nestedIndex = this.getNestedPropertySeparatorIndex(propertyName, false);
            String className = type.getFullyQualifiedName();
            if (nestedIndex >= 0) {
                String nestedPropertyName = propertyName.substring(0, nestedIndex);
                PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedPropertyName);
                String getterName = "get" + StringUtils.capitalize((String)tokens.actualName);
                IMethod getter = Introspector.findMethod((IType)type, (String)getterName, (int)0, (Introspector.Public)Introspector.Public.YES, (Introspector.Static)Introspector.Static.NO, (TypeHierarchyEngine)typeHierarchyEngine);
                if (getter == null) {
                    context.error((IResourceModelElement)property, "NO_GETTER", "No getter found for nested property '" + nestedPropertyName + "' in class '" + className + "'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("PROPERTY", (Object)nestedPropertyName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName(property))});
                } else {
                    tokens.keys;
                }
            } else {
                int mappedIndex = propertyName.indexOf(91);
                if (mappedIndex != -1) {
                    propertyName = propertyName.substring(0, mappedIndex);
                }
                if (!Introspector.isValidPropertyName((String)propertyName)) {
                    context.error((IResourceModelElement)property, "INVALID_PROPERTY_NAME", "Invalid property name '" + propertyName + "' - not JavaBean compliant", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("PROPERTY", (Object)propertyName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName(property))});
                } else if (!Introspector.hasWritableProperty((IType)type, (String)propertyName, (TypeHierarchyEngine)typeHierarchyEngine)) {
                    context.error((IResourceModelElement)property, "NO_SETTER", "No setter found for property '" + propertyName + "' in class '" + className + "'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("PROPERTY", (Object)propertyName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName(property))});
                }
            }
        }
        catch (JavaModelException e) {
            BeansCorePlugin.log(e);
        }
    }

    private int getNestedPropertySeparatorIndex(String propertyPath, boolean last) {
        boolean inKey = false;
        int i = last ? propertyPath.length() - 1 : 0;
        while (last && i >= 0 || i < propertyPath.length()) {
            switch (propertyPath.charAt(i)) {
                case '[': 
                case ']': {
                    inKey = !inKey;
                    break;
                }
                case '.': {
                    if (inKey) break;
                    return i;
                }
            }
            if (last) {
                --i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        LinkedHashSet<String> keys = new LinkedHashSet<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'")) {
                key = key.substring(1, key.length() - 1);
            } else if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.actualName = actualName != null ? actualName : propertyName;
        tokens.canonicalName = tokens.actualName;
        if (!keys.isEmpty()) {
            PropertyTokenHolder propertyTokenHolder = tokens;
            propertyTokenHolder.canonicalName = String.valueOf(propertyTokenHolder.canonicalName) + "[" + StringUtils.collectionToDelimitedString(keys, (String)"][") + "]";
            tokens.keys = keys.toArray(new String[keys.size()]);
        }
        return tokens;
    }

    private static class PropertyTokenHolder {
        private String canonicalName;
        private String actualName;
        private String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

