/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.eclipse.internal.bamboo.core.BuildsChangedEvent;
import com.atlassian.connector.eclipse.internal.bamboo.core.PlanBranches;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BambooUtil {
    private static final String KEY_SUBSCRIBED_PLANS = "com.atlassian.connector.eclipse.bamboo.subscribedPlans";
    public static final String KEY_USE_FAVOURITES = "com.atlassian.connector.eclipse.bamboo.useFavourites";
    private static final String KEY_PLAN_BRANCHES = "com.atlassian.connector.eclipse.bamboo.planBranches";

    private BambooUtil() {
    }

    public static void setSubcribedPlans(TaskRepository repository, Collection<SubscribedPlan> plans) {
        StringBuffer sb = new StringBuffer();
        for (SubscribedPlan plan : plans) {
            sb.append(plan.getKey());
            sb.append(",");
        }
        repository.setProperty(KEY_SUBSCRIBED_PLANS, sb.toString());
    }

    public static Collection<SubscribedPlan> getSubscribedPlans(TaskRepository repository) {
        ArrayList<SubscribedPlan> plans = new ArrayList<SubscribedPlan>();
        String value = repository.getProperty(KEY_SUBSCRIBED_PLANS);
        if (value != null) {
            StringTokenizer t = new StringTokenizer(value, ",");
            while (t.hasMoreTokens()) {
                plans.add(new SubscribedPlan(t.nextToken()));
            }
        }
        return plans;
    }

    public static boolean isSameBuildPlan(BambooBuild buildOne, BambooBuild buildTwo) {
        if (!buildOne.getServerUrl().equals(buildTwo.getServerUrl())) {
            return false;
        }
        return buildOne.getPlanKey().equals(buildTwo.getPlanKey());
    }

    public static String getUrlFromBuild(BambooBuild build) {
        return String.valueOf(build.getBuildUrl()) + "-" + build.getNumber();
    }

    public static void runActionForChangedBuild(BuildsChangedEvent event, BuildChangeAction buildChangeAction) {
        if (event.getChangedBuilds().size() > 0) {
            for (TaskRepository key : event.getChangedBuilds().keySet()) {
                for (BambooBuild build : event.getChangedBuilds().get(key)) {
                    for (BambooBuild oldBuild : event.getOldBuilds().get(key)) {
                        if (!BambooUtil.isSameBuildPlan(build, oldBuild) || build.getStatus() == oldBuild.getStatus()) continue;
                        buildChangeAction.run(build, key);
                    }
                }
            }
        }
    }

    public static boolean isUseFavourites(TaskRepository taskRepository) {
        if (taskRepository == null) {
            return false;
        }
        return Boolean.valueOf(taskRepository.getProperty(KEY_USE_FAVOURITES));
    }

    public static void setUseFavourites(TaskRepository taskRepository, boolean useFavourite) {
        taskRepository.setProperty(KEY_USE_FAVOURITES, Boolean.toString(useFavourite));
    }

    public static void setPlanBranches(TaskRepository taskRepository, PlanBranches value) {
        taskRepository.setProperty(KEY_PLAN_BRANCHES, value.getText());
    }

    public static PlanBranches getPlanBranches(TaskRepository taskRepository) {
        if (taskRepository == null) {
            return PlanBranches.NO;
        }
        return PlanBranches.from(taskRepository.getProperty(KEY_PLAN_BRANCHES));
    }

    public static interface BuildChangeAction {
        public void run(BambooBuild var1, TaskRepository var2);
    }
}

