/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;

public class FeedsReader {
    private final List<SyndFeed> feeds = new ArrayList<SyndFeed>();
    private final Map<SyndFeed, String> feedsWithIcons = new HashMap<SyndFeed, String>();
    private final Map<SyndEntry, SyndFeed> feedsWithEntries = new TreeMap<SyndEntry, SyndFeed>(new SyndEntryComparator());

    public List<SyndFeed> getFeeds() {
        return this.feeds;
    }

    public Map<SyndEntry, SyndFeed> getFeedsWithEntries() {
        return this.feedsWithEntries;
    }

    public ImageDescriptor getImageDescriptorForFeed(SyndFeed feed) {
        if (this.feedsWithIcons.containsKey(feed)) {
            return IdeUiPlugin.getImageDescriptor(this.feedsWithIcons.get(feed));
        }
        return null;
    }

    public void readFeeds(Reader reader, SyndFeedInput input, String iconPath) throws IllegalArgumentException, FeedException {
        SyndFeed feed = input.build(reader);
        if (feed != null) {
            this.feeds.add(feed);
            this.feedsWithIcons.put(feed, iconPath);
            List articlesList = feed.getEntries();
            if (!articlesList.isEmpty()) {
                for (SyndEntry article : articlesList) {
                    this.feedsWithEntries.put(article, feed);
                }
            }
        }
    }

    private class SyndEntryComparator
    implements Comparator<SyndEntry> {
        private SyndEntryComparator() {
        }

        @Override
        public int compare(SyndEntry o1, SyndEntry o2) {
            Date date1 = new Date(0L);
            Date date2 = new Date(0L);
            if (o1.getUpdatedDate() != null) {
                date1 = o1.getUpdatedDate();
            } else if (o1.getPublishedDate() != null) {
                date1 = o1.getPublishedDate();
            }
            if (o2.getUpdatedDate() != null) {
                date2 = o2.getUpdatedDate();
            } else if (o2.getPublishedDate() != null) {
                date2 = o2.getPublishedDate();
            }
            return -1 * date1.compareTo(date2);
        }
    }
}

