/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizard;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagWizardRepositoryPage
extends SVNWizardPage {
    private UrlCombo toUrlCombo;
    protected Button makeParentsButton;
    protected Button sameStructureButton;
    private Table table;
    private TableViewer viewer;
    private IResource[] resources;
    private ISVNRemoteResource[] remoteResources;
    private ISVNLocalResource[] svnResources;
    private SVNUrl[] urls;
    private BranchResource[] branchResources;
    private String commonRoot;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private String[] columnHeaders = new String[]{Policy.bind("BranchTagDialog.resources")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};

    public BranchTagWizardRepositoryPage() {
        super("repositoryPage", Policy.bind("BranchTagWizardRepositoryPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/svn_wizban.png"), Policy.bind("BranchTagWizardRepositoryPage.message"));
    }

    public void createControl(Composite parent) {
        this.resources = ((BranchTagWizard)this.getWizard()).getResources();
        this.remoteResources = ((BranchTagWizard)this.getWizard()).getRemoteResources();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerLayout.marginHeight = 0;
        outerLayout.marginWidth = 0;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Group repositoryGroup = new Group(outerContainer, 0);
        repositoryGroup.setText(Policy.bind("BranchTagDialog.repository"));
        repositoryGroup.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        repositoryGroup.setLayoutData((Object)data);
        if (this.multipleSelections()) {
            int i;
            ArrayList<SVNUrl> urlArray = new ArrayList<SVNUrl>();
            if (this.resources == null) {
                i = 0;
                while (i < this.remoteResources.length) {
                    urlArray.add(this.remoteResources[i].getUrl());
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.resources.length) {
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
                    try {
                        SVNUrl url = svnResource.getStatus().getUrl();
                        if (url != null) {
                            urlArray.add(url);
                        }
                    }
                    catch (SVNException sVNException) {}
                    ++i;
                }
            }
            this.urls = new SVNUrl[urlArray.size()];
            urlArray.toArray(this.urls);
        } else if (this.resources == null) {
            this.urls = new SVNUrl[1];
            this.urls[0] = this.remoteResources[0].getUrl();
        } else {
            this.svnResources = new ISVNLocalResource[1];
            this.svnResources[0] = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]);
            try {
                this.urls = new SVNUrl[1];
                this.urls[0] = this.svnResources[0].getStatus().getUrl();
            }
            catch (SVNException sVNException) {}
        }
        Label toUrlLabel = new Label((Composite)repositoryGroup, 0);
        toUrlLabel.setText(Policy.bind("BranchTagDialog.toUrl"));
        Composite urlComposite = new Composite((Composite)repositoryGroup, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 2;
        urlLayout.marginWidth = 0;
        urlLayout.marginHeight = 0;
        urlComposite.setLayout((Layout)urlLayout);
        data = new GridData(4, 4, true, false);
        urlComposite.setLayoutData((Object)data);
        this.toUrlCombo = new UrlCombo(urlComposite, 0);
        this.toUrlCombo.init(this.resources == null ? "repositoryBrowser" : this.resources[0].getProject().getName());
        this.toUrlCombo.setLayoutData(new GridData(768));
        this.toUrlCombo.setText(this.getCommonRoot());
        this.toUrlCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagWizardRepositoryPage.this.setPageComplete(BranchTagWizardRepositoryPage.this.canFinish());
            }
        });
        Button browseButton = new Button(urlComposite, 8);
        browseButton.setText(Policy.bind("SwitchDialog.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog;
                IResource resource = null;
                if (BranchTagWizardRepositoryPage.this.resources != null && BranchTagWizardRepositoryPage.this.resources.length > 0) {
                    resource = BranchTagWizardRepositoryPage.this.resources[0];
                }
                if ((dialog = new ChooseUrlDialog(BranchTagWizardRepositoryPage.this.getShell(), resource)).open() == 0 && dialog.getUrl() != null) {
                    BranchTagWizardRepositoryPage.this.toUrlCombo.setText(dialog.getUrl());
                }
            }
        });
        this.makeParentsButton = new Button(urlComposite, 32);
        this.makeParentsButton.setText(Policy.bind("BranchTagDialog.makeParents"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.makeParentsButton.setLayoutData((Object)data);
        this.makeParentsButton.setSelection(this.settings.getBoolean("BranchTagDialog.makeParents"));
        this.makeParentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchTagWizardRepositoryPage.this.settings.put("BranchTagDialog.makeParents", BranchTagWizardRepositoryPage.this.makeParentsButton.getSelection());
            }
        });
        if (this.multipleSelections() && !this.sameParents()) {
            this.sameStructureButton = new Button(urlComposite, 32);
            this.sameStructureButton.setText(Policy.bind("BranchTagDialog.sameStructure"));
            data = new GridData();
            data.horizontalSpan = 2;
            this.sameStructureButton.setLayoutData((Object)data);
            this.sameStructureButton.setSelection(this.settings.getBoolean("BranchTagDialog.sameStructure"));
            this.sameStructureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BranchTagWizardRepositoryPage.this.settings.put("BranchTagDialog.sameStructure", BranchTagWizardRepositoryPage.this.sameStructureButton.getSelection());
                    BranchTagWizardRepositoryPage.this.viewer.refresh();
                }
            });
        }
        this.table = new Table(outerContainer, 2816);
        this.table.setHeaderVisible(true);
        data = new GridData(1808);
        data.heightHint = 75;
        this.table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new BranchContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new BranchLabelProvider(), decorator));
        int i = 0;
        while (i < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        this.viewer.setInput((Object)this);
        this.toUrlCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagWizardRepositoryPage.this.viewer.refresh();
            }
        });
        this.toUrlCombo.getCombo().setFocus();
        this.setPageComplete(this.canFinish());
        this.setControl((Control)outerContainer);
    }

    private boolean multipleSelections() {
        return this.resources != null && this.resources.length > 1 || this.remoteResources != null && this.remoteResources.length > 1;
    }

    private boolean sameParents() {
        int i = 0;
        while (i < this.branchResources.length) {
            String name = null;
            name = this.branchResources[i].getResource() == null ? this.branchResources[i].getRemoteResource().getName() : this.branchResources[i].getResource().getName();
            if (!this.branchResources[i].getPartialPath().equals(name)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getCommonRoot() {
        int i;
        if (this.commonRoot != null) {
            return this.commonRoot;
        }
        ArrayList<String> urlList = new ArrayList<String>();
        if (this.resources == null) {
            i = 0;
            while (i < this.remoteResources.length) {
                urlList.add(this.remoteResources[i].getUrl().toString());
                ++i;
            }
        } else {
            i = 0;
            while (i < this.resources.length) {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[i]);
                try {
                    String anUrl = svnResource.getStatus().getUrlString();
                    if (anUrl != null) {
                        urlList.add(anUrl);
                    }
                }
                catch (SVNException sVNException) {}
                ++i;
            }
        }
        String[] urlStrings = new String[urlList.size()];
        urlList.toArray(urlStrings);
        if (urlStrings.length == 0) {
            return null;
        }
        String urlString = urlStrings[0];
        int i2 = 0;
        block4: while (i2 < urlString.length()) {
            String partialPath = urlString.substring(0, i2 + 1);
            if (partialPath.endsWith("/")) {
                int j = 1;
                while (j < urlStrings.length) {
                    if (!urlStrings[j].startsWith(partialPath)) break block4;
                    ++j;
                }
                this.commonRoot = partialPath.substring(0, i2);
            }
            ++i2;
        }
        if (this.resources == null) {
            this.branchResources = new BranchResource[this.remoteResources.length];
            i2 = 0;
            while (i2 < this.remoteResources.length) {
                this.branchResources[i2] = new BranchResource(this.remoteResources[i2], urlStrings[i2].substring(this.commonRoot.length() + 1));
                ++i2;
            }
        } else {
            this.branchResources = new BranchResource[this.resources.length];
            i2 = 0;
            while (i2 < this.resources.length) {
                this.branchResources[i2] = new BranchResource(this.resources[i2], urlStrings[i2].substring(this.commonRoot.length() + 1));
                ++i2;
            }
        }
        if (urlStrings.length == 1) {
            return urlString;
        }
        return this.commonRoot;
    }

    private boolean canFinish() {
        return this.toUrlCombo.getText().trim().length() > 0;
    }

    public SVNUrl getUrl() {
        if (this.urls == null || this.urls.length < 1) {
            return null;
        }
        return this.urls[0];
    }

    public SVNUrl[] getUrls() {
        return this.urls;
    }

    public String getUrlText() {
        return this.toUrlCombo.getText().trim();
    }

    public void saveUrl() {
        this.toUrlCombo.saveUrl();
    }

    public ISVNLocalResource getSvnResource() {
        if (this.svnResources == null || this.svnResources.length < 1) {
            return null;
        }
        return this.svnResources[0];
    }

    public String getToUrl() {
        if (this.multipleSelections()) {
            return this.getUrlText();
        }
        return this.toUrlCombo.getText();
    }

    private class BranchResource
    implements IAdaptable {
        private IResource resource;
        private ISVNRemoteResource remoteResource;
        private String partialPath;

        public BranchResource(IResource resource, String partialPath) {
            this.resource = resource;
            this.partialPath = partialPath;
        }

        public BranchResource(ISVNRemoteResource remoteResource, String partialPath) {
            this.remoteResource = remoteResource;
            this.partialPath = partialPath;
        }

        public IResource getResource() {
            return this.resource;
        }

        public ISVNRemoteResource getRemoteResource() {
            return this.remoteResource;
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }

        public String getPartialPath() {
            return this.partialPath;
        }

        public void setPartialPath(String partialPath) {
            this.partialPath = partialPath;
        }

        public Object getAdapter(Class adapter) {
            if (IResource.class == adapter) {
                return this.resource;
            }
            return null;
        }
    }

    class BranchLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        BranchLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public String getText(Object element) {
            BranchResource branchResource = (BranchResource)element;
            if (BranchTagWizardRepositoryPage.this.multipleSelections()) {
                if (BranchTagWizardRepositoryPage.this.sameStructureButton != null && BranchTagWizardRepositoryPage.this.sameStructureButton.getSelection()) {
                    return String.valueOf(branchResource.getPartialPath()) + " [" + BranchTagWizardRepositoryPage.this.toUrlCombo.getText() + "/" + branchResource.getPartialPath() + "]";
                }
                return this.getDestinationText(branchResource);
            }
            return String.valueOf(branchResource.getPartialPath()) + " [" + BranchTagWizardRepositoryPage.this.toUrlCombo.getText() + "]";
        }

        private String getDestinationText(BranchResource branchResource) {
            String name = null;
            name = branchResource.getResource() == null ? branchResource.getRemoteResource().getName() : branchResource.getResource().getName();
            return String.valueOf(branchResource.getPartialPath()) + " [" + BranchTagWizardRepositoryPage.this.toUrlCombo.getText() + "/" + name + "]";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public Image getImage(Object element) {
            BranchResource branchResource = (BranchResource)element;
            if (branchResource.getResource() == null) {
                return this.workbenchLabelProvider.getImage((Object)branchResource.getRemoteResource());
            }
            return this.workbenchLabelProvider.getImage((Object)branchResource.getResource());
        }
    }

    class BranchContentProvider
    implements IStructuredContentProvider {
        BranchContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return BranchTagWizardRepositoryPage.this.branchResources;
        }
    }

    class TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        ITableLabelProvider provider;
        ILabelDecorator decorator;

        public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = (ITableLabelProvider)provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image decorated;
            Image image = this.provider.getColumnImage(element, columnIndex);
            if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = this.provider.getColumnText(element, columnIndex);
            return text;
        }
    }
}

