/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.operations.RevertOperation;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardRevertPage;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class RevertSynchronizeOperation
extends SVNSynchronizeOperation {
    private String url;
    private IResource[] resources;
    private IResource[] resourcesToRevert;
    private IResource[] selectedResources;
    private boolean revert;
    private boolean prompted;
    private HashMap statusMap;
    private SvnWizardRevertPage revertPage;

    public RevertSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, String url, IResource[] resources, HashMap statusMap) {
        super(configuration, elements);
        this.url = url;
        this.resources = resources;
        this.statusMap = statusMap;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.prompted) {
            return;
        }
        this.prompted = true;
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (RevertSynchronizeOperation.this.resources == null || RevertSynchronizeOperation.this.resources.length == 0) {
                    RevertSynchronizeOperation.this.revert = false;
                    return;
                }
                RevertSynchronizeOperation.this.revertPage = new SvnWizardRevertPage(RevertSynchronizeOperation.this.resources, RevertSynchronizeOperation.this.url, RevertSynchronizeOperation.this.statusMap, true);
                RevertSynchronizeOperation.this.revertPage.setResourceRemoved(SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_hidden_changes"));
                SvnWizard wizard = new SvnWizard(RevertSynchronizeOperation.this.revertPage);
                SvnWizardDialog dialog = new SvnWizardDialog(RevertSynchronizeOperation.this.getShell(), (IWizard)wizard);
                RevertSynchronizeOperation.this.revert = dialog.open() == 0;
                if (RevertSynchronizeOperation.this.revert) {
                    RevertSynchronizeOperation.this.resourcesToRevert = RevertSynchronizeOperation.this.revertPage.getSelectedResources();
                }
            }
        });
        if (this.revert) {
            boolean includesExternals = false;
            if (this.revertPage != null && !this.revertPage.isResourceRemoved()) {
                IResource[] iResourceArray = this.resourcesToRevert;
                int n = 0;
                int n2 = iResourceArray.length;
                while (n < n2) {
                    IResource resource = iResourceArray[n];
                    if (this.isExternal(resource)) {
                        includesExternals = true;
                        break;
                    }
                    ++n;
                }
            }
            RevertOperation revertOperation = null;
            if (this.revertPage != null && !this.revertPage.isResourceRemoved() && !includesExternals) {
                revertOperation = new RevertOperation(this.getPart(), this.selectedResources);
                revertOperation.setRecurse(true);
                revertOperation.setResourcesToRevert(this.resourcesToRevert);
            } else {
                revertOperation = new RevertOperation(this.getPart(), this.resourcesToRevert);
            }
            revertOperation.run();
        }
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    private boolean isExternal(IResource resource) {
        IResource parent = resource;
        while (parent != null) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)parent);
            try {
                LocalResourceStatus status = svnResource.getStatus();
                if (status.isFileExternal() || SVNStatusKind.EXTERNAL.equals((Object)status.getTextStatus())) {
                    return true;
                }
            }
            catch (SVNException sVNException) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

