/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReferenceElementFactory;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.util.ObjectUtils;

public class AopReference
implements IAopReference,
IAdaptable,
IPersistableElement {
    private transient IBean bean;
    private String beanId;
    private IResource beanResource;
    private int beanStartline;
    private IAspectDefinition definition;
    private IResource file;
    private IMember source;
    private int sourceStartLine;
    private IMember target;
    private int targetStartLine;
    private IAopReference.ADVICE_TYPE type;

    public AopReference(IAopReference.ADVICE_TYPE type, IMember source, int sourceStartLine, IMember target, int targetStartLine, IAspectDefinition def, IResource file, IBean bean) {
        this(type, source, sourceStartLine, target, targetStartLine, def, file, bean.getElementID(), bean.getElementResource(), bean.getElementStartLine());
        this.bean = bean;
    }

    public AopReference(IAopReference.ADVICE_TYPE type, IMember source, int sourceStartLine, IMember target, int targetStartLine, IAspectDefinition def, IResource file, String beanId, IResource beanResource, int beanStartline) {
        this.type = type;
        this.source = source;
        this.sourceStartLine = sourceStartLine;
        this.target = target;
        this.targetStartLine = targetStartLine;
        this.definition = def;
        this.file = file;
        this.beanId = beanId;
        this.beanResource = beanResource;
        this.beanStartline = beanStartline;
    }

    public AopReference(IAopReference.ADVICE_TYPE type, IMember source, int sourceStartLine, IMember target, int targetStartLine, IResource file, String beanId, IResource beanResource, int beanStartline) {
        this(type, source, sourceStartLine, target, targetStartLine, null, file, beanId, beanResource, beanStartline);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AopReference) {
            AopReference other = (AopReference)obj;
            if (!(this.getTarget().equals(other.getTarget()) && (this.getSource() == null && other.getSource() == null || this.getSource() != null && this.getSource().equals(other.getSource())) && this.getDefinition().getAspectStartLineNumber() == other.getDefinition().getAspectStartLineNumber())) {
                return false;
            }
            if (this.getTargetBeanId() == null && other.getTargetBeanId() == null || this.getTargetBeanId().equals(other.getTargetBeanId())) {
                return true;
            }
            IBean bean1 = this.getTargetBean();
            IBean bean2 = other.getTargetBean();
            return ObjectUtils.nullSafeEquals((Object)bean1, (Object)bean2);
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPersistableElement.class)) {
            return this;
        }
        return null;
    }

    @Override
    public IAopReference.ADVICE_TYPE getAdviceType() {
        return this.type;
    }

    @Override
    public IAspectDefinition getDefinition() {
        return this.definition;
    }

    public String getFactoryId() {
        return AopReferenceElementFactory.FACTORY_ID;
    }

    @Override
    public IResource getResource() {
        return this.file;
    }

    @Override
    public IMember getSource() {
        return this.source;
    }

    @Override
    public int getSourceStartLine() {
        return this.sourceStartLine;
    }

    @Override
    public IMember getTarget() {
        return this.target;
    }

    @Override
    public String getTargetBeanId() {
        return this.beanId;
    }

    @Override
    public IResource getTargetBeanResource() {
        return this.beanResource;
    }

    @Override
    public int getTargetBeanStartline() {
        return this.beanStartline;
    }

    @Override
    public int getTargetStartLine() {
        return this.targetStartLine;
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.source);
        hashCode = 21 + ObjectUtils.nullSafeHashCode((Object)this.target);
        hashCode = 24 + ObjectUtils.nullSafeHashCode((Object)this.file);
        hashCode = 14 + ObjectUtils.nullSafeHashCode((Object)this.beanId);
        hashCode = 12 + ObjectUtils.nullSafeHashCode((Object)this.definition.getAspectStartLineNumber());
        return hashCode;
    }

    public void saveState(IMemento memento) {
        memento.putString("advice-type", this.type.toString());
        if (this.source != null) {
            memento.putString("source", this.source.getHandleIdentifier());
            memento.putInteger("source-start-line", this.sourceStartLine);
        }
        if (this.target != null) {
            memento.putString("target", this.target.getHandleIdentifier());
            memento.putInteger("target-start-line", this.targetStartLine);
        }
        if (this.file != null) {
            memento.putString("file", this.file.getFullPath().toString());
        }
        memento.putString("bean", this.beanId);
        memento.putInteger("bean-start-line", this.beanStartline);
        if (this.beanResource != null) {
            memento.putString("bean-file", this.beanResource.getFullPath().toString());
        }
    }

    @Override
    public void setDefinition(IAspectDefinition definition) {
        this.definition = definition;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Bean definition [");
        buf.append(this.beanId);
        buf.append("] advise target [");
        buf.append(this.target);
        buf.append("] advise source [");
        buf.append(this.source);
        buf.append(" ] aspect definition [");
        buf.append(this.definition);
        buf.append("]");
        return buf.toString();
    }

    private synchronized IBean getTargetBean() {
        if (this.bean == null) {
            this.bean = AopReferenceModelUtils.getBeanFromElementId(this.beanId);
        }
        return this.bean;
    }
}

