/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizard;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewListWizardPage;
import org.jboss.tools.jst.angularjs.internal.ui.AngularJsUIImages;

public class NewListWizard
extends NewIonicWidgetWizard<NewListWizardPage> {
    public NewListWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(AngularJsUIImages.getInstance().getOrCreateImageDescriptor(AngularJsUIImages.LIST_IMAGE));
    }

    protected NewListWizardPage createPage() {
        return new NewListWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent, boolean browser) {
        IElementGenerator.ElementNode list = parent.addChild("ion-list");
        this.addAttributeIfNotEmpty(list, "delegate-handle", "delegate-handle");
        this.addID("list-", list);
        this.addAttributeIfNotEmpty(list, "class", "type");
        if (this.isTrue("show-delete")) {
            list.addAttribute("show-delete", "true");
        }
        if (this.isTrue("show-reorder")) {
            list.addAttribute("show-reorder", "true");
        }
        if (!this.isTrue("can-swipe")) {
            list.addAttribute("can-swipe", "false");
        }
        String optionLabel = ((NewListWizardPage)this.page).getEditorValue("option-button");
        boolean deleteButton = this.isTrue("delete-button");
        boolean reorderButton = this.isTrue("reorder-button");
        boolean nobutton = optionLabel.length() == 0 && !deleteButton && !reorderButton;
        int n = ((NewListWizardPage)this.page).list.getNumber();
        int i = 0;
        while (i < n) {
            String label = ((NewListWizardPage)this.page).list.getLabel(i);
            String icon = ((NewListWizardPage)this.page).list.getIcon(i);
            String style = ((NewListWizardPage)this.page).list.getStyle(i);
            boolean isDivider = ((NewListWizardPage)this.page).list.isDivider(i);
            IElementGenerator.ElementNode item = list.addChild("ion-item");
            if ((nobutton || isDivider) && icon.length() == 0) {
                item.addTextChild(label);
            } else {
                IElementGenerator.ElementNode span = item.addChild("span", label);
                if (icon.length() > 0) {
                    span.addAttribute("class", "item-icon-left");
                    span.addChild("i", "").addAttribute("class", "icon " + icon);
                }
            }
            StringBuilder cls = new StringBuilder();
            if (isDivider) {
                NewListWizard.addClass((StringBuilder)cls, (String)"item-divider");
            } else if (style.length() > 0) {
                NewListWizard.addClass((StringBuilder)cls, (String)style);
            }
            if (cls.length() > 0) {
                item.addAttribute("class", cls.toString());
            }
            if (!isDivider) {
                if (optionLabel.length() > 0) {
                    IElementGenerator.ElementNode option = item.addChild("ion-option-button", optionLabel);
                    option.addAttribute("class", "button-calm");
                    option.addAttribute("ng-click", "");
                }
                if (deleteButton) {
                    IElementGenerator.ElementNode delete = item.addChild("ion-delete-button", "");
                    delete.addAttribute("class", "ion-minus-circled");
                    delete.addAttribute("ng-click", "");
                }
                if (reorderButton) {
                    IElementGenerator.ElementNode reorder = item.addChild("ion-reorder-button", "");
                    reorder.addAttribute("class", "ion-navicon");
                    reorder.addAttribute("on-reorder", "");
                }
            }
            ++i;
        }
    }
}

