/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.ui;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.wizard.Messages;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.ui.AbstractBeanWizardPage;
import org.springframework.ide.eclipse.wizard.ui.BeanPropertiesWizardPage;
import org.springframework.ide.eclipse.wizard.ui.BeanWizardPage;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Node;

public class BeanWizard
extends Wizard
implements INewWizard {
    private IFile beanFile;
    private BeanWizardPage newBeanPage;
    private BeanPropertiesWizardPage propertiesPage;
    private IDOMDocument originalDocument;
    private IDOMElement newBean;
    private IDOMElement existingBean;
    private boolean fileBrowsingEnabled;
    private final Set<IPropertyChangeListener> propertyListeners;
    public static String[] ATTRIBUTES = new String[]{BeansSchemaConstants.ATTR_ID, BeansSchemaConstants.ATTR_NAME, BeansSchemaConstants.ATTR_CLASS, BeansSchemaConstants.ATTR_PARENT};
    public static final String IGNORE_ERROR_PREFERENCE = "beanWizardIgnoreError";

    public static boolean getIgnoreError() {
        return BeanWizard.getPreferenceStore().getBoolean(IGNORE_ERROR_PREFERENCE);
    }

    public static IPreferenceStore getPreferenceStore() {
        return WizardPlugin.getDefault().getPreferenceStore();
    }

    public BeanWizard() {
        this(Messages.getString("NewBeanWizard.TITLE"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BeanWizard(IDOMElement existingNode, IFile beanFile) {
        this(Messages.getString("ModifyBeanWizard.TITLE"));
        this.beanFile = beanFile;
        this.existingBean = existingNode;
        this.fileBrowsingEnabled = false;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        DOMModelImpl modelForRead = null;
        try {
            try {
                modelForRead = (DOMModelImpl)modelManager.getModelForRead(beanFile);
                this.originalDocument = modelForRead.getDocument();
                DOMModelImpl copiedModel = (DOMModelImpl)modelManager.createNewInstance((IStructuredModel)modelForRead);
                IDOMDocument copiedDocument = copiedModel.getDocument();
                this.newBean = (IDOMElement)copiedDocument.importNode((Node)existingNode, true);
                return;
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create bean node.", (Throwable)e));
                if (modelForRead == null) return;
                modelForRead.releaseFromRead();
                modelForRead = null;
                return;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create bean node.", (Throwable)e));
                if (modelForRead == null) return;
                modelForRead.releaseFromRead();
                modelForRead = null;
                return;
            }
        }
        finally {
            if (modelForRead != null) {
                modelForRead.releaseFromRead();
                modelForRead = null;
            }
        }
    }

    public BeanWizard(IFile beanFile) {
        this(Messages.getString("NewBeanWizard.TITLE"));
        if (beanFile != null) {
            this.setBeanFile(beanFile);
        }
    }

    public BeanWizard(IFile beanFile, boolean fileBrowsingEnabled) {
        this(beanFile);
        if (beanFile != null) {
            this.fileBrowsingEnabled = fileBrowsingEnabled;
        }
    }

    private BeanWizard(String title) {
        this.setWindowTitle(title);
        this.setDefaultPageImageDescriptor(BeansUIImages.DESC_WIZ_CONFIG);
        this.fileBrowsingEnabled = true;
        this.propertyListeners = new HashSet<IPropertyChangeListener>();
    }

    public void addPages() {
        super.addPages();
        this.newBeanPage = new BeanWizardPage("beanNewDefPage", this, this.fileBrowsingEnabled);
        this.propertiesPage = new BeanPropertiesWizardPage("beanPropertiesDefPage", this);
        this.addPage((IWizardPage)this.newBeanPage);
        this.addPage((IWizardPage)this.propertiesPage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createBean() {
        DOMModelImpl model = null;
        try {
            try {
                IDOMElement parentNode;
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.beanFile);
                IModelManager modelManager = StructuredModelManager.getModelManager();
                model = (DOMModelImpl)modelManager.getModelForEdit(this.beanFile);
                IDOMDocument document = model.getDocument();
                model.beginRecording((Object)this);
                Node nextSibling = null;
                if (this.existingBean != null) {
                    nextSibling = this.existingBean.getNextSibling();
                    parentNode = (IDOMElement)this.existingBean.getParentNode();
                    parentNode.removeChild((Node)this.existingBean);
                } else {
                    parentNode = (IDOMElement)document.getDocumentElement();
                }
                IDOMElement bean = (IDOMElement)document.importNode((Node)this.newBean, true);
                if (nextSibling != null) {
                    parentNode.insertBefore((Node)bean, nextSibling);
                } else {
                    parentNode.appendChild((Node)bean);
                }
                new ShallowFormatProcessorXML().formatNode((Node)parentNode);
                new FormatProcessorXML().formatNode((Node)bean);
                model.endRecording((Object)this);
                if (editor instanceof IConfigEditor) {
                    IConfigEditor configEditor = (IConfigEditor)editor;
                    int startOffset = bean.getStartOffset();
                    int length = bean.getEndOffset() - startOffset;
                    StructuredTextViewer textViewer = configEditor.getTextViewer();
                    textViewer.setRangeIndication(startOffset, length, true);
                    textViewer.revealRange(startOffset, length);
                }
                this.newBean = bean;
                return;
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create new bean.", (Throwable)e));
                if (model == null) return;
                model.releaseFromEdit();
                model = null;
                return;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create new bean.", (Throwable)e));
                if (model == null) return;
                model.releaseFromEdit();
                model = null;
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
                model = null;
            }
        }
    }

    public Button createIgnoreErrorButton(Composite container, AbstractBeanWizardPage page) {
        final Button ignoreErrorButton = new Button(container, 32);
        ignoreErrorButton.setText(" " + Messages.getString("NewBeanWizardPage.IGNORE_ERRORS_MESSAGE"));
        GridData buttonData = new GridData(4, 4, true, false);
        buttonData.verticalIndent = 10;
        ignoreErrorButton.setLayoutData((Object)buttonData);
        boolean ignoreError = BeanWizard.getIgnoreError();
        ignoreErrorButton.setSelection(ignoreError);
        ignoreErrorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardPlugin.getDefault().getPreferenceStore().setValue(BeanWizard.IGNORE_ERROR_PREFERENCE, ignoreErrorButton.getSelection());
            }
        });
        IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(BeanWizard.IGNORE_ERROR_PREFERENCE)) {
                    ignoreErrorButton.setSelection(BeanWizard.getPreferenceStore().getBoolean(BeanWizard.IGNORE_ERROR_PREFERENCE));
                }
            }
        };
        BeanWizard.getPreferenceStore().addPropertyChangeListener(listener);
        this.propertyListeners.add(listener);
        return ignoreErrorButton;
    }

    public void dispose() {
        for (IPropertyChangeListener listener : this.propertyListeners) {
            BeanWizard.getPreferenceStore().removePropertyChangeListener(listener);
        }
    }

    public IFile getBeanFile() {
        return this.beanFile;
    }

    public IDOMElement getNewBean() {
        return this.newBean;
    }

    public IDOMDocument getOriginalDocument() {
        return this.originalDocument;
    }

    public BeanPropertiesWizardPage getPropertiesPage() {
        return this.propertiesPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        this.createBean();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBeanFile(IFile beanFile) {
        this.beanFile = beanFile;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        DOMModelImpl modelForRead = null;
        try {
            try {
                modelForRead = (DOMModelImpl)modelManager.getModelForRead(beanFile);
                this.originalDocument = modelForRead.getDocument();
                DOMModelImpl copiedModel = (DOMModelImpl)modelManager.createNewInstance((IStructuredModel)modelForRead);
                IDOMDocument copiedDocument = copiedModel.getDocument();
                this.newBean = (IDOMElement)copiedDocument.createElementNS("http://www.springframework.org/schema/beans", BeansSchemaConstants.ELEM_BEAN);
                return;
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create bean node.", (Throwable)e));
                if (modelForRead == null) return;
                modelForRead.releaseFromRead();
                modelForRead = null;
                return;
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to create bean node.", (Throwable)e));
                if (modelForRead == null) return;
                modelForRead.releaseFromRead();
                modelForRead = null;
                return;
            }
        }
        finally {
            if (modelForRead != null) {
                modelForRead.releaseFromRead();
                modelForRead = null;
            }
        }
    }
}

