/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure.processor;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.ProcessingInfo;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.TemplateProcessor;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.TemplateProjectCreator;

public class DirectoryProcessor {
    private final ProcessingInfo processingInfo;
    private final TemplateProcessor templateProcessor;
    private final TemplateProcessor fileNameProcessor;
    private final IProject project;
    private final URI projectPath;

    public DirectoryProcessor(ProcessingInfo processingInfo, IProject project, URI projectPath) {
        this.project = project;
        this.projectPath = projectPath;
        this.templateProcessor = new TemplateProcessor(processingInfo.getTemplateReplacementContext(), processingInfo.getSpringVersion());
        this.fileNameProcessor = new TemplateProcessor(processingInfo.getResourceReplacementContext());
        this.processingInfo = processingInfo;
    }

    public IProject process(URL zipPath, Shell shell, IProgressMonitor monitor) throws IOException, URISyntaxException, CoreException {
        TemplateProjectCreator projectCreator = new TemplateProjectCreator(this.project, this.projectPath, zipPath, shell, this.templateProcessor, this.fileNameProcessor, this.processingInfo);
        return projectCreator.createProject(monitor);
    }
}

