/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizard;
import org.springframework.ide.eclipse.wizard.template.ProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.ProjectWizardDescriptor;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfo;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoLoader;
import org.springsource.ide.eclipse.commons.ui.UiStatusHandler;

public abstract class SpringProjectWizardSection {
    private final NewSpringProjectWizard wizard;

    public SpringProjectWizardSection(NewSpringProjectWizard wizard) {
        this.wizard = wizard;
    }

    protected NewSpringProjectWizard getWizard() {
        return this.wizard;
    }

    public void cancel() {
    }

    protected WizardUIInfo getUIInfo(Template template) {
        try {
            return new WizardUIInfoLoader().getUIInfo(template);
        }
        catch (CoreException e1) {
            this.handleError(e1.getStatus());
            return null;
        }
    }

    protected void handleError(IStatus status) {
        UiStatusHandler.logAndDisplay((IStatus)status);
    }

    public boolean hasNextPage(IWizardPage currentPage) {
        return false;
    }

    public List<IWizardPage> loadPages() {
        return null;
    }

    public abstract IWizardPage getNextPage(IWizardPage var1);

    public abstract boolean canProvide(ProjectWizardDescriptor var1);

    public abstract ProjectConfiguration getProjectConfiguration() throws CoreException;

    public boolean canFinish() {
        return this.getWizard().getModel().selectedTemplate.getValue() != null;
    }
}

