/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.content;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportStrategy;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.NullImportStrategy;

public enum BuildType {
    MAVEN("pom.xml", "org.springframework.ide.eclipse.wizard.gettingstarted.importing.MavenStrategy", "Can not use Maven: M2E (Eclipse Maven Tooling) is not installed"),
    GRADLE("build.gradle", "org.springframework.ide.eclipse.wizard.gettingstarted.importing.GradleStrategy", "Can not use Gradle: STS Gradle Tooling is not installed. You can install it from the STS Dashboard."),
    GENERAL(null, "org.springframework.ide.eclipse.wizard.gettingstarted.importing.GeneralProjectStrategy", "NA", "General");

    private Path buildScriptPath;
    private String klass;
    private String notInstalledMessage;
    private ImportStrategy importStrategy;
    private String displayName;
    public static final BuildType DEFAULT;

    static {
        DEFAULT = MAVEN;
    }

    private BuildType(String buildScriptPath, String importStrategyClass, String notInstalledMessage) {
        if (buildScriptPath != null) {
            this.buildScriptPath = new Path(buildScriptPath);
        }
        this.klass = importStrategyClass;
        this.notInstalledMessage = notInstalledMessage;
    }

    private BuildType(String buildScriptPath, String importStrategyClass, String notInstalledMessage, String displayName) {
        this(buildScriptPath, importStrategyClass, notInstalledMessage);
        this.displayName = displayName;
    }

    public IPath getBuildScript() {
        return this.buildScriptPath;
    }

    public ImportStrategy getImportStrategy() {
        if (this.importStrategy == null) {
            try {
                this.importStrategy = (ImportStrategy)Class.forName(this.klass).newInstance();
            }
            catch (Throwable e) {
                WizardPlugin.log(e);
                this.importStrategy = new NullImportStrategy(this.name(), this.notInstalledMessage);
            }
        }
        return this.importStrategy;
    }

    public String displayName() {
        if (this.displayName == null) {
            String name = this.name();
            this.displayName = String.valueOf(name.substring(0, 1)) + name.substring(1).toLowerCase();
        }
        return this.displayName;
    }

    public String getNotInstalledMessage() {
        return this.notInstalledMessage;
    }
}

