/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.TableViewerSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.github.ui.gist.GistAttachmentSorter;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.commands.OpenTaskAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiMenus;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;

public class GistAttachmentPart
extends AbstractTaskEditorPart {
    private static final String ID_POPUP_MENU = "org.eclipse.mylyn.tasks.ui.editor.menu.attachments";
    private final String[] attachmentsColumns = new String[]{org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorAttachmentPart_Name, org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorAttachmentPart_Size, org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorAttachmentPart_Creator};
    private final int[] attachmentsColumnWidths = new int[]{150, 70, 100};
    private List<TaskAttribute> attachments;
    private boolean hasIncoming;
    private MenuManager menuManager;
    private Composite attachmentsComposite;
    private Table attachmentsTable;

    public GistAttachmentPart() {
        this.setPartName(Messages.GistAttachmentPart_PartName);
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        final Section section = this.createSection(parent, toolkit, this.hasIncoming);
        section.setText(String.valueOf(this.getPartName()) + " (" + this.attachments.size() + ")");
        if (this.hasIncoming) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (GistAttachmentPart.this.attachmentsComposite == null) {
                        GistAttachmentPart.this.expandSection(toolkit, section);
                        GistAttachmentPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, section);
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.attachmentsComposite = toolkit.createComposite((Composite)section);
        this.attachmentsComposite.setLayout((Layout)EditorUtil.createSectionClientLayout());
        this.attachmentsComposite.setLayoutData((Object)new GridData(1808));
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        if (this.attachments.size() > 0) {
            this.createAttachmentTable(toolkit, this.attachmentsComposite);
        } else {
            Label label = toolkit.createLabel(this.attachmentsComposite, org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorAttachmentPart_No_attachments);
            this.getTaskEditorPage().registerDefaultDropListener((Control)label);
        }
        this.createButtons(this.attachmentsComposite, toolkit);
        toolkit.paintBordersFor(this.attachmentsComposite);
        section.setClient((Control)this.attachmentsComposite);
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        super.dispose();
    }

    private void createAttachmentTable(FormToolkit toolkit, Composite attachmentsComposite) {
        this.attachmentsTable = toolkit.createTable(attachmentsComposite, 65538);
        this.attachmentsTable.setLinesVisible(true);
        this.attachmentsTable.setHeaderVisible(true);
        this.attachmentsTable.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(500, -1).applyTo((Control)this.attachmentsTable);
        this.attachmentsTable.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        int i = 0;
        while (i < this.attachmentsColumns.length) {
            TableColumn column = new TableColumn(this.attachmentsTable, 16384, i);
            column.setText(this.attachmentsColumns[i]);
            column.setWidth(this.attachmentsColumnWidths[i]);
            column.setMoveable(true);
            if (i == 0) {
                this.attachmentsTable.setSortColumn(column);
                this.attachmentsTable.setSortDirection(1024);
            }
            ++i;
        }
        this.attachmentsTable.getColumn(1).setAlignment(131072);
        TableViewer attachmentsViewer = new TableViewer(this.attachmentsTable);
        attachmentsViewer.setUseHashlookup(true);
        attachmentsViewer.setColumnProperties(this.attachmentsColumns);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)attachmentsViewer, (int)2);
        attachmentsViewer.setSorter((ViewerSorter)new GistAttachmentSorter());
        ArrayList<TaskAttachment> attachmentList = new ArrayList<TaskAttachment>(this.attachments.size());
        for (TaskAttribute attribute : this.attachments) {
            TaskAttachment taskAttachment = new TaskAttachment(this.getModel().getTaskRepository(), this.getModel().getTask(), attribute);
            this.getTaskData().getAttributeMapper().updateTaskAttachment((ITaskAttachment)taskAttachment, attribute);
            attachmentList.add(taskAttachment);
        }
        attachmentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        attachmentsViewer.setLabelProvider((IBaseLabelProvider)new AttachmentTableLabelProvider(this.getModel(), this.getTaskEditorPage().getAttributeEditorToolkit()){

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex > 0) {
                    ++columnIndex;
                }
                return super.getColumnText(element, columnIndex);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex > 0) {
                    ++columnIndex;
                }
                return super.getColumnImage(element, columnIndex);
            }
        });
        attachmentsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                GistAttachmentPart.this.openAttachments(event);
            }
        });
        attachmentsViewer.addSelectionChangedListener((ISelectionChangedListener)this.getTaskEditorPage());
        attachmentsViewer.setInput((Object)attachmentList.toArray());
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TasksUiMenus.fillTaskAttachmentMenu((IMenuManager)manager);
            }
        });
        this.getTaskEditorPage().getEditorSite().registerContextMenu(ID_POPUP_MENU, this.menuManager, (ISelectionProvider)attachmentsViewer, true);
        Menu menu = this.menuManager.createContextMenu((Control)this.attachmentsTable);
        this.attachmentsTable.setMenu(menu);
        new TableViewerSupport(attachmentsViewer, this.getStateFile());
    }

    private File getStateFile() {
        IPath stateLocation = Platform.getStateLocation((Bundle)TasksUiPlugin.getDefault().getBundle());
        return stateLocation.append("GistAttachmentPart.xml").toFile();
    }

    private void createButtons(Composite attachmentsComposite, FormToolkit toolkit) {
        Composite attachmentControlsComposite = toolkit.createComposite(attachmentsComposite);
        attachmentControlsComposite.setLayout((Layout)new GridLayout(2, false));
        attachmentControlsComposite.setLayoutData((Object)new GridData(1));
        Button attachFileButton = toolkit.createButton(attachmentControlsComposite, org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorAttachmentPart_Attach_, 8);
        attachFileButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FILE_PLAIN));
        attachFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorUtil.openNewAttachmentWizard((AbstractTaskEditorPage)GistAttachmentPart.this.getTaskEditorPage(), (TaskAttachmentWizard.Mode)TaskAttachmentWizard.Mode.DEFAULT, null);
            }
        });
        this.getTaskEditorPage().registerDefaultDropListener((Control)attachFileButton);
    }

    private void initialize() {
        this.attachments = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "attachment");
        for (TaskAttribute attachmentAttribute : this.attachments) {
            if (!this.getModel().hasIncomingChanges(attachmentAttribute)) continue;
            this.hasIncoming = true;
            break;
        }
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
        Action attachFileAction = new Action(){

            public void run() {
                EditorUtil.openNewAttachmentWizard((AbstractTaskEditorPage)GistAttachmentPart.this.getTaskEditorPage(), (TaskAttachmentWizard.Mode)TaskAttachmentWizard.Mode.DEFAULT, null);
            }
        };
        attachFileAction.setToolTipText(org.eclipse.mylyn.internal.tasks.ui.editors.Messages.TaskEditorAttachmentPart_Attach_);
        attachFileAction.setImageDescriptor(CommonImages.FILE_PLAIN_SMALL);
        toolBarManager.add((IAction)attachFileAction);
    }

    protected void openAttachments(OpenEvent event) {
        ArrayList<ITaskAttachment> attachments = new ArrayList<ITaskAttachment>();
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        List items = selection.toList();
        for (Object item : items) {
            if (!(item instanceof ITaskAttachment)) continue;
            attachments.add((ITaskAttachment)item);
        }
        if (attachments.isEmpty()) {
            return;
        }
        IWorkbenchPage page = this.getTaskEditorPage().getSite().getWorkbenchWindow().getActivePage();
        try {
            OpenTaskAttachmentHandler.openAttachments((IWorkbenchPage)page, attachments);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public boolean setFormInput(Object input) {
        if (input instanceof String && this.attachments != null) {
            for (TaskAttribute attachmentAttribute : this.attachments) {
                if (!input.equals(attachmentAttribute.getId())) continue;
                CommonFormUtil.setExpanded((ExpandableComposite)((ExpandableComposite)this.getControl()), (boolean)true);
                return this.selectReveal(attachmentAttribute);
            }
        }
        return super.setFormInput(input);
    }

    public boolean selectReveal(TaskAttribute attachmentAttribute) {
        if (attachmentAttribute == null || this.attachmentsTable == null) {
            return false;
        }
        TableItem[] attachments = this.attachmentsTable.getItems();
        int index = 0;
        TableItem[] tableItemArray = attachments;
        int n = attachments.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskAttachment attachmentData;
            TableItem attachment = tableItemArray[n2];
            Object data = attachment.getData();
            if (data instanceof ITaskAttachment && (attachmentData = (ITaskAttachment)data).getTaskAttribute().getValue().equals(attachmentAttribute.getValue())) {
                this.attachmentsTable.deselectAll();
                this.attachmentsTable.select(index);
                IManagedForm mform = this.getManagedForm();
                ScrolledForm form = mform.getForm();
                EditorUtil.focusOn((ScrolledForm)form, (Control)this.attachmentsTable);
                return true;
            }
            ++index;
            ++n2;
        }
        return false;
    }
}

