/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import java.util.Set;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.core.internal.model.ProfileAwareBeansComponent;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

public class ExternalBeanHyperlink
implements IHyperlink {
    private final IRegion region;
    private final ISourceModelElement modelElement;

    public ExternalBeanHyperlink(ISourceModelElement bean, IRegion region) {
        this.region = region;
        this.modelElement = bean;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.modelElement != null) {
            StringBuilder str = new StringBuilder();
            str.append("Navigate to ");
            str.append(this.modelElement.getElementName());
            IModelElement parent = this.modelElement.getElementParent();
            if (parent instanceof ProfileAwareBeansComponent) {
                ProfileAwareBeansComponent beans = (ProfileAwareBeansComponent)parent;
                Set profiles = beans.getProfiles();
                str.append(" in profile");
                if (profiles.size() > 1) {
                    str.append("s");
                }
                str.append(" ");
                boolean first = true;
                for (String profile : profiles) {
                    if (!first) {
                        str.append(", ");
                    }
                    str.append("\"");
                    str.append(profile);
                    str.append("\"");
                    first = false;
                }
                str.append(" - ");
                str.append(this.modelElement.getElementResource().getName());
                return str.toString();
            }
        }
        return "Navigate to " + this.modelElement.getElementName();
    }

    public void open() {
        BeansUIUtils.openInEditor((IResourceModelElement)this.modelElement);
    }
}

