/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.CommandFactory;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandListener;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommand;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IFrameworkCommandDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.JavaParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.ui.FrameworkUIActivator;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.contentassist.JavaContentAssistUIAdapter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.utils.ProjectFilter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.utils.SelectionUtils;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.GenericWizardCommandListPage;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.GenericWizardCommandParametersPage;

public abstract class GenericCommandWizard
extends Wizard
implements ICommandListener {
    protected GenericWizardCommandListPage commandListPage;
    protected GenericWizardCommandParametersPage parameterPage;
    private String wizardTitle;
    private boolean orderRequiredParameters = true;
    private IFrameworkCommand commandInstance;
    private Collection<IProject> projects;
    private IProject selectedProject;

    public GenericCommandWizard(IFrameworkCommand command, String title, String description, String imageLocation, Collection<IProject> projects) {
        this.commandInstance = command;
        this.projects = projects;
        this.wizardTitle = title;
        this.setWindowTitle(this.wizardTitle);
        this.setDefaultPageImageDescriptor(FrameworkUIActivator.getImageDescriptor(imageLocation));
        this.setNeedsProgressMonitor(true);
        this.commandListPage = this.createCommandListPage();
        this.commandListPage.setWizard((IWizard)this);
        this.setForcePreviousAndNextButtons(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List<IProject> selectedProjects = SelectionUtils.getProjects((ISelection)selection, this.getProjectFilter());
        if (selectedProjects.size() > 0) {
            this.setSelectedProject(selectedProjects.get(0));
        }
    }

    protected ProjectFilter getProjectFilter() {
        return ProjectFilter.anyProject;
    }

    public GenericCommandWizard(IFrameworkCommand command, String title, String description, String imageLocation, Collection<IProject> projects, boolean orderRequiredParameters) {
        this(command, title, description, imageLocation, projects);
        this.orderRequiredParameters = orderRequiredParameters;
    }

    protected GenericWizardCommandListPage createCommandListPage() {
        return new GenericWizardCommandListPage(this.getWindowTitle());
    }

    public void setSelectedProject(IProject project) {
        if (project.equals((Object)this.selectedProject)) {
            return;
        }
        this.selectedProject = project;
        if (this.commandListPage != null) {
            this.commandListPage.setProjectSelectionInPage();
        }
        if (this.parameterPage != null) {
            this.parameterPage.setProjectSelectionInPage();
        }
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    public Collection<IProject> getProjectList() {
        return this.projects;
    }

    public GenericCommandWizard(String title, String description, String imageLocation) {
        this(null, title, description, imageLocation, null);
    }

    public GenericCommandWizard(String title, String description, String imageLocation, Collection<IProject> projects) {
        this(null, title, description, imageLocation, projects);
    }

    public IFrameworkCommand getCommandInstance() {
        return this.commandInstance;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.commandListPage);
    }

    public IWizardPage getStartingPage() {
        if (this.commandListPage != null && this.commandInstance != null) {
            IFrameworkCommandDescriptor descriptor = this.commandInstance.getCommandDescriptor();
            this.commandListPage.addCommandDescriptor(descriptor);
            this.commandListPage.selectCommandInViewer(descriptor);
            this.parameterPage = this.createParameterPage(this.commandInstance);
            return this.parameterPage;
        }
        return super.getStartingPage();
    }

    protected void resizeWizard(Control control) {
        Point size = control.computeSize(-1, -1);
        IWizardContainer container = this.getContainer();
        if (container != null) {
            container.getShell().setSize(size);
        }
    }

    protected GenericWizardCommandParametersPage createParameterPage(IFrameworkCommand command) {
        if (command == null) {
            return null;
        }
        GenericWizardCommandParametersPage page = new GenericWizardCommandParametersPage(command);
        page.setWizard((IWizard)this);
        return page;
    }

    public boolean canFinish() {
        if (this.parameterPage != null && this.getContainer().getCurrentPage() == this.parameterPage) {
            return this.parameterPage.isPageComplete();
        }
        if (this.isConfiguredCommandSelected()) {
            return true;
        }
        return super.canFinish();
    }

    protected boolean isConfiguredCommandSelected() {
        if (this.commandInstance == null) {
            return false;
        }
        List parameters = this.commandInstance.getParameters();
        if (parameters != null) {
            for (ICommandParameter parameter : parameters) {
                if (!parameter.getParameterDescriptor().isMandatory() || parameter.hasValue()) continue;
                return false;
            }
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.commandListPage) {
            if (this.parameterPage != null && this.parameterPage.getCommand() == this.commandInstance) {
                return this.parameterPage;
            }
            if (this.commandInstance != null) {
                this.parameterPage = this.createParameterPage(this.commandInstance);
                return this.parameterPage;
            }
        }
        return super.getNextPage(page);
    }

    public boolean setCommandInstance(IFrameworkCommandDescriptor descriptor) {
        if (this.commandInstance != null && this.commandInstance.getCommandDescriptor().equals(descriptor)) {
            return false;
        }
        this.commandInstance = this.createCommand(descriptor);
        return true;
    }

    protected IFrameworkCommand createCommand(IFrameworkCommandDescriptor descriptor) {
        return CommandFactory.createCommandInstance((IFrameworkCommandDescriptor)descriptor);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.parameterPage) {
            return this.commandListPage;
        }
        return super.getPreviousPage(page);
    }

    public void addCommandDescriptor(IFrameworkCommandDescriptor commandDescriptor) {
        final IFrameworkCommandDescriptor commandDesc = commandDescriptor;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (GenericCommandWizard.this.commandListPage != null && !GenericCommandWizard.this.commandListPage.containsCommandDescriptor(commandDesc)) {
                    GenericCommandWizard.this.commandListPage.addCommandDescriptor(commandDesc);
                }
            }
        });
    }

    protected void executeCommand(IFrameworkCommand command) {
    }

    public boolean performFinish() {
        boolean canFinish = this.canFinish();
        if (canFinish) {
            this.executeCommand(this.commandInstance);
        }
        return canFinish;
    }

    public JavaContentAssistUIAdapter getJavaContentAssistUIAdapter(JavaParameterDescriptor parameter) {
        return new JavaContentAssistUIAdapter(parameter);
    }

    protected boolean groupRequiredParameters() {
        return this.orderRequiredParameters;
    }
}

