/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.FactoryMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.InitDestroyMethodContentAssistCalculator;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.springframework.ide.eclipse.quickfix.processors.BeanReferenceQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.ClassAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.ConstructorArgQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.MethodAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.PropertyAttributeQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.RequiredPropertyQuickAssistProcessor;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final String ERROR_ID_CLASS_NOT_FOUND = "CLASS_NOT_FOUND";
    private static final String ERROR_ID_UNDEFINED_REFERENCED_BEAN = "UNDEFINED_REFERENCED_BEAN";
    private static final String ERROR_ID_NO_SETTER = "NO_SETTER";
    private static final String ERROR_ID_NO_GETTER = "NO_GETTER";
    private static final String ERROR_ID_KEY = "errorId";
    private static final String ERROR_ID_UNDEFINED_INIT = "UNDEFINED_INIT_METHOD";
    private static final String ERROR_ID_UNDEFINED_DESTROY = "UNDEFINED_DESTROY_METHOD";
    private static final String ERROR_ID_REQUIRED_PROPERTY_MISSING = "REQUIRED_PROPERTY_MISSING";
    private static final String ERROR_ID_NO_CONSTRUCTOR = "NO_CONSTRUCTOR";
    private static final String ERROR_ID_UNDEFINED_FACTORY_BEAN_METHOD = "UNDEFINED_FACTORY_BEAN_METHOD";

    private IDOMNode findMatchedBean(NodeList nodes, String beanName) {
        if (nodes == null) {
            return null;
        }
        int i = 0;
        while (i < nodes.getLength()) {
            IDOMNode childNode;
            Node item = nodes.item(i);
            if (BeansSchemaConstants.ELEM_BEAN.equals(item.getNodeName()) && item.getAttributes() != null) {
                AttrImpl attr = (AttrImpl)item.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_NAME);
                if (attr != null && beanName.equals(attr.getNodeValue())) {
                    return (IDOMNode)item;
                }
                attr = (AttrImpl)item.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_ID);
                if (attr != null && beanName.equals(attr.getNodeValue())) {
                    return (IDOMNode)item;
                }
            }
            if ((childNode = this.findMatchedBean(item.getChildNodes(), beanName)) != null) {
                return childNode;
            }
            ++i;
        }
        return null;
    }

    private NodeInfo findNodeInfo(IDOMNode node, String attrName, String attrValue) {
        if (node != null) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    AttrImpl attribute = (AttrImpl)attributes.item(i);
                    if ((attrName == null || attrName.equals(attribute.getNodeName())) && attrValue != null && attrValue.equals(attribute.getNodeValue())) {
                        int offset = attribute.getValueRegionStartOffset();
                        if (attribute.getValueRegion().getLength() > attrValue.length()) {
                            ++offset;
                        }
                        int length = attribute.getNodeValue() == null ? 0 : attribute.getNodeValue().length();
                        return new NodeInfo(node, offset, length);
                    }
                    ++i;
                }
            }
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                NodeInfo info = this.findNodeInfo((IDOMNode)children.item(i), attrName, attrValue);
                if (info != null) {
                    return info;
                }
                ++i;
            }
        }
        return null;
    }

    protected NodeInfo findNodeInfo(IMarker marker, String attrName, String attrValue) {
        IDOMModel model = null;
        try {
            IDOMDocument document;
            String beanName = (String)marker.getAttribute("BEAN_NAME");
            if (beanName == null) {
                return null;
            }
            IFile file = (IFile)marker.getResource();
            model = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(file);
            if (model != null && (document = model.getDocument()) != null) {
                NodeList nodes = document.getChildNodes();
                IDOMNode node = this.findMatchedBean(nodes, beanName);
                NodeInfo nodeInfo = this.findNodeInfo(node, attrName, attrValue);
                return nodeInfo;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ICompletionProposal[] proposals = null;
        IEditorPart editor = XmlQuickFixUtil.getMarkedEditor(marker);
        if (editor != null && editor.isDirty()) {
            return new IMarkerResolution[0];
        }
        try {
            String beanName;
            NodeInfo nodeInfo;
            IFile file;
            String errorId = (String)marker.getAttribute(ERROR_ID_KEY);
            String className = marker.getAttribute("CLASS", null);
            IFile iFile = file = marker.getResource() instanceof IFile ? (IFile)marker.getResource() : null;
            if (ERROR_ID_NO_CONSTRUCTOR.equals(errorId)) {
                int numArgument = marker.getAttribute("NUM_ARGUMENT", 0);
                if (className != null && (nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_CLASS, className)) != null && file != null) {
                    ArrayList<String> argClassNames = new ArrayList<String>();
                    int i = 0;
                    while (i < numArgument) {
                        argClassNames.add("Object");
                        ++i;
                    }
                    proposals = new ConstructorArgQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, className, file.getProject(), false, argClassNames, nodeInfo.node).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_REQUIRED_PROPERTY_MISSING.equals(errorId)) {
                NodeInfo nodeInfo2;
                ArrayList<String> requiredProperties = new ArrayList<String>();
                String requiredProperty = null;
                int counter = 1;
                do {
                    if ((requiredProperty = marker.getAttribute("MISSING_PROPERTIES" + counter, null)) != null) {
                        requiredProperties.add(requiredProperty);
                    }
                    ++counter;
                } while (requiredProperty != null);
                if (requiredProperties.size() > 0 && className != null && (nodeInfo2 = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_CLASS, className)) != null) {
                    proposals = new RequiredPropertyQuickAssistProcessor(nodeInfo2.offset, nodeInfo2.length, className, false, requiredProperties, nodeInfo2.node).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_UNDEFINED_DESTROY.equals(errorId)) {
                String methodName = marker.getAttribute("METHOD", null);
                if (methodName != null && className != null && (nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_DESTROY_METHOD, methodName)) != null && file != null) {
                    proposals = new MethodAttributeQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, className, methodName, true, nodeInfo.node, BeansSchemaConstants.ATTR_DESTROY_METHOD, file.getProject(), false, (IContentAssistCalculator)new InitDestroyMethodContentAssistCalculator(), file).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_UNDEFINED_INIT.equals(errorId)) {
                String methodName = marker.getAttribute("METHOD", null);
                if (methodName != null && className != null && (nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_INIT_METHOD, methodName)) != null && file != null) {
                    proposals = new MethodAttributeQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, className, methodName, true, nodeInfo.node, BeansSchemaConstants.ATTR_INIT_METHOD, file.getProject(), false, (IContentAssistCalculator)new InitDestroyMethodContentAssistCalculator(), file).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_UNDEFINED_FACTORY_BEAN_METHOD.equals(errorId)) {
                String methodName = marker.getAttribute("METHOD", null);
                if (methodName != null && className != null && (nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_FACTORY_METHOD, methodName)) != null && file != null) {
                    proposals = new MethodAttributeQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, className, methodName, true, nodeInfo.node, BeansSchemaConstants.ATTR_FACTORY_METHOD, file.getProject(), false, (IContentAssistCalculator)new FactoryMethodContentAssistCalculator(), file).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_NO_SETTER.equals(errorId)) {
                String propertyName = marker.getAttribute("PROPERTY", null);
                if (className != null && propertyName != null && file != null && (nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_NAME, propertyName)) != null) {
                    proposals = new PropertyAttributeQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, className, propertyName, file.getProject(), false, PropertyAttributeQuickAssistProcessor.Type.SETTER).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_NO_GETTER.equals(errorId)) {
                String propertyName = marker.getAttribute("PROPERTY", null);
                if (className != null && propertyName != null && file != null && (nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_NAME, propertyName)) != null) {
                    proposals = new PropertyAttributeQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, className, propertyName, file.getProject(), false, PropertyAttributeQuickAssistProcessor.Type.GETTER).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_CLASS_NOT_FOUND.equals(errorId)) {
                NodeInfo nodeInfo3;
                if (className != null && (nodeInfo3 = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_CLASS, className)) != null && file != null) {
                    proposals = new ClassAttributeQuickAssistProcessor(nodeInfo3.offset, nodeInfo3.length, className, file.getProject(), false, new HashSet(), 0).computeQuickAssistProposals(null);
                }
            } else if (ERROR_ID_UNDEFINED_REFERENCED_BEAN.equals(errorId) && (beanName = marker.getAttribute("BEAN", null)) != null) {
                nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_REF, beanName);
                if (nodeInfo == null) {
                    nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_PARENT, beanName);
                }
                if (nodeInfo == null) {
                    nodeInfo = this.findNodeInfo(marker, BeansSchemaConstants.ATTR_FACTORY_BEAN, beanName);
                }
                if (nodeInfo != null && file != null) {
                    proposals = new BeanReferenceQuickAssistProcessor(nodeInfo.offset, nodeInfo.length, beanName, false, nodeInfo.node, BeansSchemaConstants.ATTR_REF, beanName, file).computeQuickAssistProposals(null);
                }
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
        if (proposals != null) {
            ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
            ICompletionProposal[] iCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                void proposal = iCompletionProposalArray[n2];
                if (proposal instanceof IMarkerResolution) {
                    resolutions.add((IMarkerResolution)proposal);
                }
                ++n2;
            }
            return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
        }
        return new IMarkerResolution[0];
    }

    public boolean hasResolutions(IMarker marker) {
        String errorId = marker.getAttribute(ERROR_ID_KEY, null);
        String className = marker.getAttribute("CLASS", null);
        if (errorId == null) {
            return false;
        }
        if (ERROR_ID_NO_CONSTRUCTOR.equals(errorId)) {
            return className != null;
        }
        if (ERROR_ID_REQUIRED_PROPERTY_MISSING.equals(errorId)) {
            return true;
        }
        if (ERROR_ID_UNDEFINED_DESTROY.equals(errorId)) {
            String methodName = marker.getAttribute("METHOD", null);
            return methodName != null && className != null;
        }
        if (ERROR_ID_UNDEFINED_INIT.equals(errorId)) {
            String methodName = marker.getAttribute("METHOD", null);
            return methodName != null && className != null;
        }
        if (ERROR_ID_UNDEFINED_FACTORY_BEAN_METHOD.equals(errorId)) {
            String methodName = marker.getAttribute("METHOD", null);
            return methodName != null && className != null;
        }
        if (ERROR_ID_NO_SETTER.equals(errorId)) {
            String propertyName = marker.getAttribute("PROPERTY", null);
            return propertyName != null && className != null;
        }
        if (ERROR_ID_NO_GETTER.equals(errorId)) {
            String propertyName = marker.getAttribute("PROPERTY", null);
            return propertyName != null && className != null;
        }
        if (ERROR_ID_CLASS_NOT_FOUND.equals(errorId)) {
            return className != null;
        }
        if (ERROR_ID_UNDEFINED_REFERENCED_BEAN.equals(errorId)) {
            String beanName = marker.getAttribute("BEAN", null);
            return beanName != null;
        }
        return false;
    }

    private class NodeInfo {
        private final IDOMNode node;
        private final int offset;
        private final int length;

        private NodeInfo(IDOMNode node, int offset, int length) {
            this.node = node;
            this.offset = offset;
            this.length = length;
        }
    }
}

